/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.item;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import net.dries007.tfc.common.component.item.ItemComponent;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public record ItemListComponent(List<ItemStack> contents) {
    public static final Codec<ItemListComponent> CODEC = ItemStack.OPTIONAL_CODEC.listOf().xmap(ItemListComponent::new, ItemListComponent::contents);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemListComponent> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()).map(ItemListComponent::new, ItemListComponent::contents);
    public static final ItemListComponent EMPTY = ItemListComponent.of(List.of());

    public static ItemListComponent of(IItemHandler inventory) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)inventory.getSlots());
        Helpers.copyTo((ImmutableList.Builder<ItemStack>)builder, inventory);
        return new ItemListComponent((List<ItemStack>)builder.build());
    }

    public static ItemListComponent of(List<ItemStack> content) {
        return new ItemListComponent(List.copyOf(content));
    }

    public void addTooltipInfo(List<Component> text) {
        for (ItemStack stack : this.contents) {
            if (stack.isEmpty()) continue;
            text.add((Component)Tooltips.countOfItem(stack).withStyle(ChatFormatting.GRAY));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ItemListComponent)) return false;
        ItemListComponent that = (ItemListComponent)obj;
        if (!ItemComponent.equals(this.contents, that.contents)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return ItemComponent.hashCode(this.contents);
    }
}

