/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.util.data.KnappingPattern;
import net.dries007.tfc.util.data.KnappingType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class KnappingContainer
extends ItemStackContainer
implements ButtonHandlerContainer,
ISlotCallback {
    public static final int SLOT_OUTPUT = 0;
    private final KnappingType knappingType;
    private final KnappingPattern pattern;
    private final ItemStack originalStack;
    private boolean requiresReset;
    private boolean hasBeenModified;
    private boolean hasConsumedIngredient;

    public static KnappingContainer create(ItemStack stack, KnappingType type, InteractionHand hand, int slot, Inventory playerInventory, int windowId) {
        return (KnappingContainer)new KnappingContainer((MenuType)TFCContainerTypes.KNAPPING.get(), type, windowId, playerInventory, stack, hand, slot).init(playerInventory, 20);
    }

    public KnappingContainer(MenuType<?> containerType, KnappingType knappingType, int windowId, Inventory playerInv, ItemStack stack, InteractionHand hand, int slot) {
        super(containerType, windowId, playerInv, stack, hand, slot);
        this.knappingType = knappingType;
        this.pattern = new KnappingPattern();
        this.hasBeenModified = false;
        this.hasConsumedIngredient = false;
        this.originalStack = stack.copy();
        this.setRequiresReset(false);
    }

    public KnappingType getKnappingType() {
        return this.knappingType;
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable CompoundTag extraNBT) {
        this.pattern.set(buttonID, false);
        if (!this.hasBeenModified) {
            if (!this.player.isCreative() && !this.knappingType.consumeAfterComplete()) {
                this.stack.shrink(this.knappingType.amountToConsume());
            }
            this.hasBeenModified = true;
        }
        Slot slot = (Slot)this.slots.get(0);
        Level level = this.player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            @Nullable KnappingRecipe recipe = KnappingRecipe.get((Level)level2, this);
            slot.set(recipe != null ? recipe.assemble() : ItemStack.EMPTY);
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return !this.getTargetStack().isEmpty() || this.hasBeenModified && !this.knappingType.consumeAfterComplete();
    }

    public void removed(Player player) {
        Slot slot = (Slot)this.slots.get(0);
        ItemStack stack = slot.getItem();
        if (!stack.isEmpty() && !player.level().isClientSide()) {
            player.getInventory().placeItemBackInInventory(stack);
            this.consumeIngredientStackAfterComplete();
        }
        super.removed(player);
    }

    public KnappingPattern getPattern() {
        return this.pattern;
    }

    public ItemStack getOriginalStack() {
        return this.originalStack;
    }

    @Override
    public void onSlotTake(Player player, int slot, ItemStack stack) {
        this.resetPattern();
    }

    public boolean requiresReset() {
        return this.requiresReset;
    }

    public void setRequiresReset(boolean requiresReset) {
        this.requiresReset = requiresReset;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.CONTAINER -> {
                if (!this.moveItemStackTo(stack, this.containerSlots, this.containerSlots + 36, true)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, this.containerSlots, this.containerSlots + 27, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.MAIN_INVENTORY -> !this.moveItemStackTo(stack, this.containerSlots + 27, this.containerSlots + 36, false);
        };
    }

    @Override
    protected void addContainerSlots() {
        this.addSlot((Slot)new CallbackSlot(this, (IItemHandler)new ItemStackHandler(1), 0, 128, 46));
    }

    private void resetPattern() {
        this.pattern.setAll(false);
        this.setRequiresReset(true);
        this.consumeIngredientStackAfterComplete();
    }

    protected void consumeIngredientStackAfterComplete() {
        if (this.knappingType.consumeAfterComplete() && !this.hasConsumedIngredient) {
            this.stack.shrink(this.knappingType.amountToConsume());
            this.hasConsumedIngredient = true;
        }
    }
}

