/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.blockentities.LargeVesselBlockEntity;
import net.dries007.tfc.common.blocks.LargeVesselBlock;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.PestContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.container.slot.CallbackSlot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LargeVesselContainer
extends BlockEntityContainer<LargeVesselBlockEntity>
implements ButtonHandlerContainer,
PestContainer {
    public static LargeVesselContainer create(LargeVesselBlockEntity vessel, Inventory playerInventory, int windowId) {
        return (LargeVesselContainer)new LargeVesselContainer(vessel, windowId).init(playerInventory);
    }

    public LargeVesselContainer(LargeVesselBlockEntity vessel, int windowId) {
        super((MenuType)TFCContainerTypes.LARGE_VESSEL.get(), windowId, vessel);
    }

    public void clicked(int slot, int button, ClickType clickType, Player player) {
        if (slot >= 0 && slot < 9 && ((Boolean)((LargeVesselBlockEntity)this.blockEntity).getBlockState().getValue((Property)SealableDeviceBlock.SEALED)).booleanValue()) {
            return;
        }
        super.clicked(slot, button, clickType, player);
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable CompoundTag extraNBT) {
        Level level = ((LargeVesselBlockEntity)this.blockEntity).getLevel();
        if (level != null) {
            LargeVesselBlock.toggleSeal(level, ((LargeVesselBlockEntity)this.blockEntity).getBlockPos(), ((LargeVesselBlockEntity)this.blockEntity).getBlockState(), ((LargeVesselBlockEntity)this.blockEntity).getType());
        }
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        if (((Boolean)((LargeVesselBlockEntity)this.blockEntity).getBlockState().getValue((Property)LargeVesselBlock.SEALED)).booleanValue()) {
            return true;
        }
        return switch (this.typeOf(slotIndex)) {
            default -> throw new MatchException(null, null);
            case Container.IndexType.MAIN_INVENTORY, Container.IndexType.HOTBAR -> {
                if (!this.moveItemStackTo(stack, 0, 9, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.CONTAINER -> !this.moveItemStackTo(stack, this.containerSlots, this.slots.size(), false);
        };
    }

    @Override
    protected void addContainerSlots() {
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 0, 62, 19));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 1, 80, 19));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 2, 98, 19));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 3, 62, 37));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 4, 80, 37));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 5, 98, 37));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 6, 62, 55));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 7, 80, 55));
        this.addSlot((Slot)new CallbackSlot(this.blockEntity, 8, 98, 55));
    }

    @Override
    public boolean canBeInfested() {
        return !this.isSealed();
    }

    public boolean isSealed() {
        return ((LargeVesselBlockEntity)this.blockEntity).getBlockState().hasProperty((Property)LargeVesselBlock.SEALED) && (Boolean)((LargeVesselBlockEntity)this.blockEntity).getBlockState().getValue((Property)LargeVesselBlock.SEALED) != false;
    }
}

