/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.effect;

import java.util.function.Supplier;
import net.dries007.tfc.common.effect.TFCMobEffect;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TFCEffects {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"tfc");
    public static final Id<MobEffect> PINNED = TFCEffects.register("pinned", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 5926017).addAttributeModifier(Attributes.MOVEMENT_SPEED, Helpers.identifier("effect.pinned"), -7.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(NeoForgeMod.SWIM_SPEED, Helpers.identifier("effect.swim_speed"), -7.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Id<MobEffect> INK = TFCEffects.register("ink", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 4731988));
    public static final Id<MobEffect> GLOW_INK = TFCEffects.register("glow_ink", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 4255207));
    public static final Id<MobEffect> OVERBURDENED = TFCEffects.register("overburdened", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 2504281).addAttributeModifier(Attributes.MOVEMENT_SPEED, Helpers.identifier("effect.move"), -7.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(NeoForgeMod.SWIM_SPEED, Helpers.identifier("effect.swim_speed"), -7.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Id<MobEffect> EXHAUSTED = TFCEffects.register("exhausted", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 6715941));
    public static final Id<MobEffect> THIRST = TFCEffects.register("thirst", () -> new TFCMobEffect(MobEffectCategory.HARMFUL, 10333649));

    public static <T extends MobEffect> Id<T> register(String name, Supplier<T> supplier) {
        return new Id(EFFECTS.register(name, supplier));
    }

    public record Id<T extends MobEffect>(DeferredHolder<MobEffect, T> holder) implements RegistryHolder<MobEffect, T>
    {
    }
}

