/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.entities.predator.Predator;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class AggressiveSwim
extends Behavior<Predator> {
    private final float jumpChance;

    public AggressiveSwim(float jumpChance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.REGISTERED));
        this.jumpChance = jumpChance;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, Predator predator) {
        return predator.isInWater() && predator.getFluidTypeHeight((FluidType)NeoForgeMod.WATER_TYPE.value()) > predator.getFluidJumpThreshold() || predator.isInLava() || predator.isInFluidType((fluidType, height) -> predator.canSwimInFluidType((FluidType)fluidType) && height > predator.getFluidJumpThreshold());
    }

    protected boolean canStillUse(ServerLevel level, Predator entity, long gameTime) {
        return this.checkExtraStartConditions(level, entity);
    }

    protected void tick(ServerLevel level, Predator predator, long gameTime) {
        if (predator.getRandom().nextFloat() < this.jumpChance) {
            predator.getJumpControl().jump();
            Brain<Predator> brain = predator.getBrain();
            brain.getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(entity -> {
                Vec3 dist = entity.position().subtract(predator.position());
                if (dist.lengthSqr() > 9.0 && entity.getY() - 3.0 <= predator.getY()) {
                    Vec3 scaled = dist.normalize().scale(0.25);
                    predator.setDeltaMovement(predator.getDeltaMovement().add(scaled.x, 0.1, scaled.z));
                }
            });
        }
    }
}

