/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.pet.MoveToTargetSinkIfNotSleeping;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.dries007.tfc.common.entities.ai.predator.PredatorBehaviors;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.behavior.TryFindWater;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class AmphibiousPredatorAi {
    public static final ImmutableList<? extends SensorType<? extends Sensor<? super Predator>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY);
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = (ImmutableList)Util.make(() -> {
        ArrayList list = Lists.newArrayList(PredatorAi.MEMORY_TYPES);
        return ImmutableList.copyOf((Collection)list);
    });
    public static final int MAX_WANDER_DISTANCE = 10000;
    public static final int MAX_ATTACK_DISTANCE = 6400;

    public static Brain<?> makeBrain(Brain<? extends Predator> brain, Predator predator) {
        AmphibiousPredatorAi.initCoreActivity(brain);
        AmphibiousPredatorAi.initHuntActivity(brain);
        AmphibiousPredatorAi.initRetreatActivity(brain);
        PredatorAi.initRestActivity(brain);
        AmphibiousPredatorAi.initFightActivity(brain);
        brain.setSchedule(predator.diurnal ? (Schedule)TFCBrain.DIURNAL.get() : (Schedule)TFCBrain.NOCTURNAL.get());
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity((Activity)TFCBrain.HUNT.get());
        brain.setActiveActivityIfPossible((Activity)TFCBrain.HUNT.get());
        brain.updateActivityFromSchedule(predator.level().getDayTime(), predator.level().getGameTime());
        return brain;
    }

    public static void updateActivity(Predator predator) {
        Brain<Predator> brain = predator.getBrain();
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.FIGHT));
        if (brain.getActiveNonCoreActivity().isPresent()) {
            Activity current = (Activity)brain.getActiveNonCoreActivity().get();
            if (current == Activity.FIGHT && !brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
                brain.updateActivityFromSchedule(predator.level().getDayTime(), predator.level().getGameTime());
            } else if (current == Activity.AVOID && !brain.hasMemoryValue(MemoryModuleType.PACIFIED)) {
                brain.updateActivityFromSchedule(predator.level().getDayTime(), predator.level().getGameTime());
            }
        }
        predator.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    public static void initCoreActivity(Brain<? extends Predator> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)((Object)new MoveToTargetSinkIfNotSleeping()), (Object)new CountDownCooldownTicks((MemoryModuleType)TFCBrain.WAKEUP_TICKS.get())));
    }

    public static void initHuntActivity(Brain<? extends Predator> brain) {
        brain.addActivity((Activity)TFCBrain.HUNT.get(), ImmutableList.of((Object)Pair.of((Object)0, PredatorBehaviors.becomePassiveIf(p -> p.getHealth() < 5.0f, 200)), (Object)Pair.of((Object)1, (Object)StartAttacking.create(PredatorAi::getAttackTarget)), (Object)Pair.of((Object)2, SetLookTarget.create(8.0f, UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)3, (Object)TryFindWater.create((int)6, (float)1.0f)), (Object)Pair.of((Object)5, (Object)RandomStroll.swim((float)1.0f)), (Object)Pair.of((Object)6, (Object)RandomStroll.stroll((float)1.0f, (boolean)false)), (Object)Pair.of((Object)7, (Object)SetWalkTargetFromLookTarget.create(AmphibiousPredatorAi::canSetWalkTargetFromLookTarget, AmphibiousPredatorAi::getSpeedModifier, (int)3)), (Object)Pair.of((Object)10, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)11, PredatorAi.createIdleMovementBehaviors()), (Object)Pair.of((Object)12, PredatorBehaviors.tickScheduleAndWake())));
    }

    public static void initRetreatActivity(Brain<? extends Predator> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)BehaviorBuilder.triggerIf(PredatorAi::hasNearbyAttacker, (OneShot)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY, (float)1.2f, (int)16, (boolean)true)), (Object)StrollToPoi.create((MemoryModuleType)MemoryModuleType.HOME, (float)0.7f, (int)5, (int)10000), PredatorAi.createIdleMovementBehaviors()), MemoryModuleType.PACIFIED);
    }

    public static void initFightActivity(Brain<? extends Predator> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of(PredatorBehaviors.becomePassiveIf(p -> p.getHealth() < 5.0f, 200), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create(AmphibiousPredatorAi::getSpeedModifier), (Object)MeleeAttack.create((int)40), PredatorBehaviors.stopAttackingIfTooFarFromHome()), MemoryModuleType.ATTACK_TARGET);
    }

    private static float getSpeedModifier(LivingEntity entity) {
        return entity.isInWaterOrBubble() ? 1.6f : 1.0f;
    }

    private static boolean canSetWalkTargetFromLookTarget(LivingEntity entity) {
        Level level = entity.level();
        Optional tracker = entity.getBrain().getMemory(MemoryModuleType.LOOK_TARGET);
        if (tracker.isPresent()) {
            BlockPos pos = ((PositionTracker)tracker.get()).currentBlockPosition();
            return EnvironmentHelpers.isWaterAt((LevelAccessor)level, pos) == entity.isInWaterOrBubble();
        }
        return false;
    }
}

