/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.predator.AggressiveSwim;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.dries007.tfc.common.entities.ai.predator.PredatorBehaviors;
import net.dries007.tfc.common.entities.predator.Predator;
import net.minecraft.Util;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import org.jetbrains.annotations.Nullable;

public class PackPredatorAi {
    public static final ImmutableList<SensorType<? extends Sensor<? super PackPredator>>> SENSOR_TYPES = (ImmutableList)Util.make(() -> {
        ArrayList list = Lists.newArrayList(PredatorAi.SENSOR_TYPES);
        list.add((SensorType)TFCBrain.PACK_LEADER_SENSOR.get());
        list.add((SensorType)TFCBrain.TEMPTATION_SENSOR.get());
        return ImmutableList.copyOf((Collection)list);
    });
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = (ImmutableList)Util.make(() -> {
        ArrayList list = Lists.newArrayList(PredatorAi.MEMORY_TYPES);
        list.add((MemoryModuleType)TFCBrain.ALPHA.get());
        list.add(MemoryModuleType.TEMPTING_PLAYER);
        list.add(MemoryModuleType.IS_PANICKING);
        list.add(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS);
        list.add(MemoryModuleType.IS_TEMPTED);
        return ImmutableList.copyOf((Collection)list);
    });

    public static Brain<?> makeBrain(Brain<? extends Predator> brain, Predator predator) {
        PackPredatorAi.initCoreActivity(brain);
        PackPredatorAi.initHuntActivity(brain);
        PredatorAi.initRetreatActivity(brain);
        PredatorAi.initRestActivity(brain);
        PredatorAi.initFightActivity(brain);
        brain.setSchedule(predator.diurnal ? (Schedule)TFCBrain.DIURNAL.get() : (Schedule)TFCBrain.NOCTURNAL.get());
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity((Activity)TFCBrain.HUNT.get());
        brain.setActiveActivityIfPossible((Activity)TFCBrain.HUNT.get());
        brain.updateActivityFromSchedule(predator.level().getDayTime(), predator.level().getGameTime());
        return brain;
    }

    public static void initCoreActivity(Brain<? extends Predator> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)((Object)new AggressiveSwim(0.8f)), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    public static void initHuntActivity(Brain<? extends Predator> brain) {
        brain.addActivity((Activity)TFCBrain.HUNT.get(), 10, ImmutableList.of(PredatorBehaviors.becomePassiveIf(p -> p.getHealth() < 5.0f || PackPredatorAi.isAlphaPassive(p), 200), PredatorBehaviors.becomePassiveIf(p -> p.getBrain().hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER), 400), (Object)StartAttacking.create(PackPredatorAi::getAttackTarget), SetLookTarget.create(8.0f, UniformInt.of((int)30, (int)60)), PredatorBehaviors.findNewHome(), PredatorBehaviors.listenToAlpha(), (Object)new FollowTemptation(e -> Float.valueOf(e.isBaby() ? 1.5f : 1.2f)), (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f), PredatorAi.createIdleMovementBehaviors(), PredatorBehaviors.tickScheduleAndWake()));
    }

    public static boolean isAlphaPassive(Predator predator) {
        return PackPredatorAi.getAlpha(predator).getBrain().getMemory(MemoryModuleType.PACIFIED).orElse(false);
    }

    public static Optional<? extends LivingEntity> getAttackTarget(Predator predator) {
        return PackPredatorAi.isAlpha(predator) ? PredatorAi.getAttackTarget(predator) : PackPredatorAi.getMemoryFromAlpha(predator, MemoryModuleType.ATTACK_TARGET);
    }

    public static <T> Optional<T> getMemoryFromAlpha(Predator predator, MemoryModuleType<T> memory) {
        return PackPredatorAi.getAlpha(predator).getBrain().getMemory(memory);
    }

    public static boolean isNotAlpha(Predator predator) {
        return !PackPredatorAi.getAlpha(predator).equals(predator);
    }

    public static boolean isAlpha(Predator predator) {
        return PackPredatorAi.getAlpha(predator).equals(predator);
    }

    public static void alertOthers(PackPredator predator, @Nullable LivingEntity target) {
        predator.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).ifPresent(list -> list.forEach(entity -> {
            if (entity instanceof PackPredator) {
                PackPredator otherPredator = (PackPredator)entity;
                if (target != null) {
                    otherPredator.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
                }
                otherPredator.getBrain().eraseMemory(MemoryModuleType.HUNTED_RECENTLY);
                otherPredator.getBrain().eraseMemory(MemoryModuleType.PACIFIED);
                otherPredator.getBrain().setActiveActivityIfPossible(Activity.FIGHT);
                otherPredator.setSleeping(false);
            }
        }));
    }

    public static PackPredator getAlpha(Predator predator) {
        return predator.getBrain().getMemory((MemoryModuleType)TFCBrain.ALPHA.get()).orElse((PackPredator)predator);
    }
}

