/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.dries007.tfc.common.entities.ai.predator.PackPredatorAi;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.dries007.tfc.common.entities.predator.Predator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.phys.Vec3;

public final class PredatorBehaviors {
    public static OneShot<Predator> becomePassiveIf(Predicate<Predator> predicate, int ticks) {
        return BehaviorBuilder.triggerIf(predicate, (OneShot)BehaviorBuilder.create(instance -> instance.group((App)instance.registered(MemoryModuleType.ATTACK_TARGET), (App)instance.absent(MemoryModuleType.PACIFIED)).apply((Applicative)instance, (attackMemory, passiveMemory) -> (level, predator, time) -> {
            attackMemory.erase();
            passiveMemory.setWithExpiry((Object)true, (long)ticks);
            return true;
        })));
    }

    public static BehaviorControl<Mob> stopAttackingIfTooFarFromHome() {
        return PredatorBehaviors.stopAttackingIf((predator, target) -> PredatorAi.getDistanceFromHomeSqr((LivingEntity)predator) > 6400.0, (predator, target) -> {
            if (target.isDeadOrDying()) {
                Brain brain = predator.getBrain();
                brain.setMemoryWithExpiry(MemoryModuleType.HUNTED_RECENTLY, (Object)true, 12000L);
                if (brain.hasMemoryValue(MemoryModuleType.HURT_BY_ENTITY)) {
                    brain.eraseMemory(MemoryModuleType.HURT_BY_ENTITY);
                }
            }
        });
    }

    public static <E extends Mob> BehaviorControl<E> stopAttackingIf(BiPredicate<E, LivingEntity> canStopAttacking, BiConsumer<Mob, LivingEntity> onStopAttacking) {
        return BehaviorBuilder.create(instance -> instance.group((App)instance.present(MemoryModuleType.ATTACK_TARGET), (App)instance.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)instance, (attackTarget, cantReachWalkTargetSince) -> (level, attackerMob, gameTime) -> {
            LivingEntity attackedMob = (LivingEntity)instance.get(attackTarget);
            if (!attackerMob.canAttack(attackedMob) || PredatorBehaviors.isTiredOfTryingToReachTarget(attackerMob, instance.tryGet(cantReachWalkTargetSince)) || !attackedMob.isAlive() || attackedMob.level() != attackerMob.level() || canStopAttacking.test(attackerMob, attackedMob)) {
                onStopAttacking.accept((Mob)attackerMob, attackedMob);
                attackTarget.erase();
            }
            return true;
        }));
    }

    public static OneShot<Predator> startSleeping() {
        return BehaviorBuilder.triggerIf(entity -> PredatorAi.getDistanceFromHomeSqr((LivingEntity)entity) < 25.0 && !entity.isSleeping() && !entity.isInWaterOrBubble(), (OneShot)BehaviorBuilder.create(instance -> instance.group((App)instance.absent(MemoryModuleType.ATTACK_TARGET), (App)instance.absent((MemoryModuleType)TFCBrain.WAKEUP_TICKS.get()), (App)instance.registered(MemoryModuleType.WALK_TARGET), (App)instance.registered(MemoryModuleType.LOOK_TARGET)).apply((Applicative)instance, (attack, tick, walk, look) -> (level, predator, time) -> {
            walk.erase();
            look.erase();
            predator.setSleeping(true);
            return true;
        })));
    }

    public static OneShot<Predator> tickScheduleAndWake() {
        return BehaviorBuilder.create(instance -> instance.group((App)instance.absent(MemoryModuleType.ATTACK_TARGET)).apply((Applicative)instance, attack -> (level, predator, time) -> {
            Optional before = predator.getBrain().getActiveNonCoreActivity();
            predator.getBrain().updateActivityFromSchedule(level.getDayTime(), level.getGameTime());
            Optional after = predator.getBrain().getActiveNonCoreActivity();
            if (before.isPresent() && after.isPresent() && before.get() == Activity.REST && after.get() != Activity.REST) {
                predator.setSleeping(false);
                return true;
            }
            return false;
        }));
    }

    public static OneShot<Predator> wakeFromDisturbance() {
        return BehaviorBuilder.triggerIf(entity -> (PredatorAi.getDistanceFromHomeSqr((LivingEntity)entity) > 25.0 || entity.isInWaterOrBubble() || !entity.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, (LivingEntity)entity, entity.getBoundingBox()).isEmpty()) && entity.isSleeping(), (OneShot)BehaviorBuilder.create(instance -> instance.group((App)instance.absent(MemoryModuleType.ATTACK_TARGET)).apply((Applicative)instance, attack -> (level, predator, time) -> {
            predator.setSleeping(false);
            predator.getBrain().setMemory((MemoryModuleType)TFCBrain.WAKEUP_TICKS.get(), (Object)100);
            return true;
        })));
    }

    public static OneShot<Predator> findNewHome() {
        return BehaviorBuilder.triggerIf(predator -> PredatorAi.getDistanceFromHomeSqr((LivingEntity)predator) > 10000.0 || PredatorAi.getDistanceFromHomeSqr((LivingEntity)predator) < 9.0 && predator.isInWaterOrBubble(), (OneShot)BehaviorBuilder.create(instance -> instance.group((App)instance.present(MemoryModuleType.HOME), (App)instance.registered(MemoryModuleType.WALK_TARGET)).apply((Applicative)instance, (homeMemory, walkMemory) -> (level, predator, time) -> {
            Vec3 found = LandRandomPos.getPos((PathfinderMob)predator, (int)10, (int)5);
            if (found != null) {
                homeMemory.set((Object)GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)BlockPos.containing((Position)found)));
                walkMemory.set((Object)new WalkTarget(found, 1.0f, 16));
                return true;
            }
            return false;
        })));
    }

    public static OneShot<Predator> listenToAlpha() {
        return BehaviorBuilder.triggerIf(PackPredatorAi::isNotAlpha, (OneShot)BehaviorBuilder.create(instance -> instance.group((App)instance.registered(MemoryModuleType.WALK_TARGET), (App)instance.registered(MemoryModuleType.HOME), (App)instance.absent(MemoryModuleType.ATTACK_TARGET)).apply((Applicative)instance, (walk, home, attackTarget) -> (level, predator, time) -> {
            PackPredator alpha = PackPredatorAi.getAlpha(predator);
            Brain alphaBrain = alpha.getBrain();
            alphaBrain.getMemory(MemoryModuleType.HOME).ifPresent(arg_0 -> ((MemoryAccessor)home).set(arg_0));
            if (!alpha.equals(predator)) {
                walk.set((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)alpha, false), 1.1f, 6));
            }
            return true;
        })));
    }

    private static boolean isTiredOfTryingToReachTarget(LivingEntity entity, Optional<Long> timeSinceInvalid) {
        return timeSinceInvalid.isPresent() && entity.level().getGameTime() - timeSinceInvalid.get() > 200L;
    }
}

