/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.prey.AvoidPredatorAndRammersBehavior;
import net.dries007.tfc.common.entities.ai.prey.PestFeastBehavior;
import net.dries007.tfc.common.entities.ai.prey.PreyAi;
import net.dries007.tfc.common.entities.prey.Pest;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class PestAi {
    public static final ImmutableList<SensorType<? extends Sensor<? super Pest>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY);
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.AVOID_TARGET, (Object)MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object)((MemoryModuleType)TFCBrain.SMELLY_POS.get()));

    public static Brain<?> makeBrain(Brain<? extends Pest> brain) {
        PestAi.initCoreActivity(brain);
        PestAi.initIdleActivity(brain);
        PestAi.initRetreatActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void initCoreActivity(Brain<? extends Pest> brain) {
        PreyAi.initCoreActivity(brain);
    }

    public static void initIdleActivity(Brain<? extends Pest> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, SetLookTarget.create(EntityType.PLAYER, 6.0f, UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, AvoidPredatorAndRammersBehavior.create(false)), (Object)Pair.of((Object)2, (Object)((Object)new PestFeastBehavior((MemoryModuleType)TFCBrain.SMELLY_POS.get(), false))), (Object)Pair.of((Object)3, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)4, PreyAi.createIdleMovementBehaviors())));
    }

    public static void initRetreatActivity(Brain<? extends Pest> brain) {
        PreyAi.initRetreatActivity(brain);
    }

    public static void setSmelledPos(Pest pest, BlockPos pos) {
        pest.getBrain().setMemory((MemoryModuleType)TFCBrain.SMELLY_POS.get(), (Object)GlobalPos.of((ResourceKey)pest.level().dimension(), (BlockPos)pos));
    }
}

