/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.dries007.tfc.common.entities.ai.prey.AvoidPredatorsBehavior;
import net.dries007.tfc.common.entities.ai.prey.PrepareRamNearestTargetTFC;
import net.dries007.tfc.common.entities.ai.prey.PreyAi;
import net.dries007.tfc.common.entities.ai.prey.RamTargetTFC;
import net.dries007.tfc.common.entities.prey.RammingPrey;
import net.dries007.tfc.util.Helpers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.schedule.Activity;

public class RammingPreyAi {
    public static final int RAM_PREPARE_TIME = 20;
    public static final int RAM_MAX_DISTANCE = 9;
    private static final float SPEED_MULTIPLIER_WHEN_PREPARING_TO_RAM = 1.6f;
    public static final float ADULT_RAM_KNOCKBACK_FORCE = 2.5f;
    public static final float BABY_RAM_KNOCKBACK_FORCE = 1.0f;
    private static final UniformInt TIME_BETWEEN_RAMS_MALE = UniformInt.of((int)600, (int)1000);
    private static final UniformInt TIME_BETWEEN_RAMS_FEMALE = UniformInt.of((int)1000, (int)1600);
    protected static final TargetingConditions RAM_TARGET_CONDITIONS = TargetingConditions.forCombat().selector(target -> target.level().getWorldBorder().isWithinBounds(target.getBoundingBox()) && !(target instanceof RammingPrey) && !Helpers.isEntity((Entity)target, TFCTags.Entities.NOT_RAMMED_BY_RAMMERS));
    protected static final TargetingConditions RAM_TARGET_CONDITIONS_ADULT_MALE = TargetingConditions.forCombat().selector(target -> target.level().getWorldBorder().isWithinBounds(target.getBoundingBox()) && (!(target instanceof RammingPrey) || Helpers.isEntity((Entity)target, TFCTags.Entities.NOT_RAMMED_BY_RAMMERS) || ((RammingPrey)target).isMale() && !target.isBaby() && !((double)(target.getHealth() / target.getMaxHealth()) < 0.7)));

    public static void initMemories(RammingPrey rammingPrey, RandomSource random) {
        Brain<RammingPrey> brain = rammingPrey.getBrain();
        brain.setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)(rammingPrey.isMale() ? TIME_BETWEEN_RAMS_MALE : TIME_BETWEEN_RAMS_FEMALE).sample(random));
    }

    public static Brain<?> makeBrain(Brain<? extends RammingPrey> brain) {
        RammingPreyAi.initCoreActivity(brain);
        RammingPreyAi.initIdleActivity(brain);
        RammingPreyAi.initRetreatActivity(brain);
        RammingPreyAi.initRamActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void initCoreActivity(Brain<? extends RammingPrey> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.7f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.RAM_COOLDOWN_TICKS), (Object)EraseMemoryIf.create(PredatorAi::hasNearbyAttacker, (MemoryModuleType)MemoryModuleType.RAM_COOLDOWN_TICKS), (Object)EraseMemoryIf.create(RammingPreyAi::attackerHasLeft, (MemoryModuleType)MemoryModuleType.HURT_BY_ENTITY)));
    }

    public static void initIdleActivity(Brain<? extends RammingPrey> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, SetLookTarget.create(EntityType.PLAYER, 6.0f, UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, AvoidPredatorsBehavior.create(true)), (Object)Pair.of((Object)2, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)3, RammingPreyAi.createIdleMovementBehaviors())));
    }

    public static void initRetreatActivity(Brain<? extends RammingPrey> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.1f, (int)15, (boolean)false), RammingPreyAi.createIdleMovementBehaviors(), SetLookTarget.create(8.0f, UniformInt.of((int)30, (int)60)), (Object)EraseMemoryIf.create(PreyAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    public static RunOne<RammingPrey> createIdleMovementBehaviors() {
        return new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static void initRamActivity(Brain<? extends RammingPrey> brain) {
        brain.addActivityWithConditions(Activity.RAM, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new RamTargetTFC(rammingPrey -> rammingPrey.isMale() ? TIME_BETWEEN_RAMS_MALE : TIME_BETWEEN_RAMS_FEMALE, 3.0f, rammingPrey -> rammingPrey.isBaby() ? 1.0 : 2.5, rammingPrey -> (SoundEvent)TFCSounds.RAMMING_IMPACT.get()))), (Object)Pair.of((Object)1, new PrepareRamNearestTargetTFC<RammingPrey>(rammingPrey -> 10, 1.6f, 20, rammingPrey -> rammingPrey.getAttackSound().get()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(RammingPrey prey) {
        prey.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.RAM, (Object)Activity.IDLE));
    }

    public static boolean attackerHasLeft(LivingEntity rammingPrey) {
        return rammingPrey.getBrain().getMemory(MemoryModuleType.HURT_BY_ENTITY).map(entity -> entity.distanceToSqr((Entity)rammingPrey) < 400.0).orElse(false) == false;
    }
}

