/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.GetHookedGoal;
import net.dries007.tfc.common.entities.ai.TFCFishMoveControl;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.util.Helpers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FreshwaterFish
extends Salmon
implements AquaticMob {
    private final TFCSounds.FishId sound;
    private final Supplier<? extends Item> bucket;

    public FreshwaterFish(EntityType<? extends FreshwaterFish> type, Level level, TFCSounds.FishId sound, Supplier<? extends Item> bucket) {
        super(type, level);
        this.sound = sound;
        this.bucket = bucket;
        this.moveControl = new TFCFishMoveControl((PathfinderMob)this);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new GetHookedGoal((PathfinderMob)this));
        EntityHelpers.replaceAvoidEntityGoal((PathfinderMob)this, this.goalSelector, 2);
    }

    protected SoundEvent getFlopSound() {
        return this.sound.flop().get();
    }

    protected SoundEvent getAmbientSound() {
        return this.sound.ambient().get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return this.sound.hurt().get();
    }

    protected SoundEvent getDeathSound() {
        return this.sound.death().get();
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)this.bucket.get());
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        return EntityHelpers.bucketMobPickup(player, hand, this).orElse(super.mobInteract(player, hand));
    }

    @Override
    public boolean canSpawnIn(Fluid fluid) {
        return fluid.isSame((Fluid)Fluids.WATER);
    }

    protected float getBlockSpeedFactor() {
        return Helpers.isBlock(this.level().getBlockState(this.blockPosition()), TFCTags.Blocks.ANIMAL_IGNORED_PLANTS) ? 1.0f : super.getBlockSpeedFactor();
    }
}

