/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import java.util.Arrays;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.TFCFishMoveControl;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class Jellyfish
extends AbstractSchoolingFish
implements AquaticMob {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID_TFC = SynchedEntityData.defineId(Jellyfish.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Jellyfish(EntityType<? extends AbstractSchoolingFish> type, Level level) {
        super(type, level);
        this.moveControl = new TFCFishMoveControl((PathfinderMob)this);
    }

    public Type getVariant() {
        return Type.byId((Integer)this.entityData.get(DATA_TYPE_ID_TFC));
    }

    public void setVariant(Type variant) {
        this.entityData.set(DATA_TYPE_ID_TFC, (Object)variant.getId());
    }

    public void saveToBucketTag(ItemStack stack) {
        super.saveToBucketTag(stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, tag -> tag.putInt("BucketVariantTag", this.getVariant().getId()));
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)TFCItems.JELLYFISH_BUCKET.get());
    }

    public void playerTouch(Player player) {
        player.hurt(this.damageSources().mobAttack((LivingEntity)this), 1.0f);
        super.playerTouch(player);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnData);
        this.setVariant(Type.byId(level.getRandom().nextInt(Type.SIZE)));
        return spawnData;
    }

    public void loadFromBucketTag(CompoundTag tag) {
        super.loadFromBucketTag(tag);
        if (tag.contains("BucketVariantTag", 3)) {
            this.setVariant(Type.byId(tag.getInt("BucketVariantTag")));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TYPE_ID_TFC, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("Variant", this.getVariant().getSerializedName());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(Type.byName(tag.getString("Variant")));
    }

    protected SoundEvent getFlopSound() {
        return TFCSounds.JELLYFISH.flop().get();
    }

    protected SoundEvent getAmbientSound() {
        return TFCSounds.JELLYFISH.ambient().get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return TFCSounds.JELLYFISH.hurt().get();
    }

    protected SoundEvent getDeathSound() {
        return TFCSounds.JELLYFISH.death().get();
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        return EntityHelpers.bucketMobPickup(player, hand, this).orElse(super.mobInteract(player, hand));
    }

    @Override
    public boolean canSpawnIn(Fluid fluid) {
        return fluid.isSame((Fluid)TFCFluids.SALT_WATER.getSource());
    }

    protected float getBlockSpeedFactor() {
        return Helpers.isBlock(this.level().getBlockState(this.blockPosition()), TFCTags.Blocks.ANIMAL_IGNORED_PLANTS) ? 1.0f : super.getBlockSpeedFactor();
    }

    public static enum Type implements StringRepresentable
    {
        BLUE(0, "blue"),
        RED(1, "red"),
        YELLOW(2, "yellow"),
        PURPLE(3, "purple"),
        ORANGE(4, "orange");

        public static final int SIZE;
        private static final IntFunction<Type> BY_ID;
        private static final Map<String, Type> BY_NAME;
        private final int id;
        private final String name;

        private Type(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Type byName(String name) {
            return BY_NAME.getOrDefault(name, Type.byId(0));
        }

        public static Type byId(int index) {
            return BY_ID.apply(index);
        }

        static {
            SIZE = Type.values().length;
            BY_ID = ByIdMap.continuous(Type::getId, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getSerializedName, v -> v));
        }
    }
}

