/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.effect.TFCEffects;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TFCSquid
extends Squid
implements AquaticMob {
    public static final int MAX_SIZE = 127;
    public static final int MIN_SIZE = 1;

    public TFCSquid(EntityType<? extends Squid> type, Level level) {
        super(type, level);
    }

    @Override
    public boolean canSpawnIn(Fluid fluid) {
        return Helpers.isFluid(fluid, TFCTags.Fluids.ANY_INFINITE_WATER);
    }

    public void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomMovementGoal(this));
        this.goalSelector.addGoal(2, (Goal)new FleeGoal(this));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (super.hurt(source, amount)) {
            LivingEntity livingEntity;
            if (!this.level().isClientSide && (livingEntity = this.getLastHurtByMob()) instanceof Player) {
                Player player = (Player)livingEntity;
                if (this.random.nextInt(3) == 0 && player.distanceToSqr((Entity)this) < 64.0) {
                    player.addEffect(new MobEffectInstance(this.getInkEffect(), 100));
                }
            }
            return true;
        }
        return false;
    }

    public Holder<MobEffect> getInkEffect() {
        return TFCEffects.INK.holder();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnData);
        Pair<Integer, Integer> pair = this.getSizeRangeForSpawning();
        this.setSize(Mth.nextInt((RandomSource)this.random, (int)((Integer)pair.getFirst()), (int)((Integer)pair.getSecond())), true);
        if (spawnType == MobSpawnType.NATURAL || spawnType == MobSpawnType.CHUNK_GENERATION) {
            while (level.collidesWithSuffocatingBlock((Entity)this, this.getBoundingBox())) {
                this.setSize((int)((double)this.getSize() * 0.8), true);
                if (this.getSize() >= (Integer)pair.getFirst()) continue;
                this.discard();
                return spawnData;
            }
        }
        return spawnData;
    }

    public Pair<Integer, Integer> getSizeRangeForSpawning() {
        return Pair.of((Object)22, (Object)65);
    }

    public int getSize() {
        return Mth.ceil((float)(this.getScale() / 5.0f * 128.0f));
    }

    public void setSize(int size, boolean heal) {
        AttributeInstance instance;
        size = Mth.clamp((int)size, (int)1, (int)127);
        Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue((double)size);
        if (heal) {
            this.setHealth(this.getMaxHealth());
        }
        if ((instance = this.getAttribute(Attributes.SCALE)) != null) {
            instance.setBaseValue((double)((float)size / 128.0f * 5.0f));
        }
    }

    public static class RandomMovementGoal
    extends Goal {
        private final TFCSquid squid;

        public RandomMovementGoal(TFCSquid squid) {
            this.squid = squid;
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            int ticks = this.squid.getNoActionTime();
            if (ticks > 100) {
                this.squid.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.getRandom().nextInt(RandomMovementGoal.reducedTickDelay((int)50)) == 0 || !this.squid.wasTouchingWater || !this.squid.hasMovementVector()) {
                float f = this.squid.getRandom().nextFloat() * ((float)Math.PI * 2);
                float f1 = Mth.cos((float)f) * 0.2f;
                float f2 = -0.1f + this.squid.getRandom().nextFloat() * 0.2f;
                float f3 = Mth.sin((float)f) * 0.2f;
                this.squid.setMovementVector(f1, f2, f3);
            }
        }
    }

    public static class FleeGoal
    extends Goal {
        private static final float SQUID_FLEE_SPEED = 3.0f;
        private static final float SQUID_FLEE_MIN_DISTANCE = 5.0f;
        private static final float SQUID_FLEE_MAX_DISTANCE = 10.0f;
        private int fleeTicks;
        private final TFCSquid squid;

        public FleeGoal(TFCSquid squid) {
            this.squid = squid;
        }

        public boolean canUse() {
            LivingEntity livingentity = this.squid.getLastHurtByMob();
            if (this.squid.isInWater() && livingentity != null) {
                return this.squid.distanceToSqr((Entity)livingentity) < 100.0;
            }
            return false;
        }

        public void start() {
            this.fleeTicks = 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            ++this.fleeTicks;
            LivingEntity livingentity = this.squid.getLastHurtByMob();
            if (livingentity != null) {
                Vec3 vec3 = new Vec3(this.squid.getX() - livingentity.getX(), this.squid.getY() - livingentity.getY(), this.squid.getZ() - livingentity.getZ());
                BlockState blockstate = this.squid.level().getBlockState(BlockPos.containing((double)(this.squid.getX() + vec3.x), (double)(this.squid.getY() + vec3.y), (double)(this.squid.getZ() + vec3.z)));
                FluidState fluidstate = this.squid.level().getFluidState(BlockPos.containing((double)(this.squid.getX() + vec3.x), (double)(this.squid.getY() + vec3.y), (double)(this.squid.getZ() + vec3.z)));
                if (fluidstate.is(TFCTags.Fluids.ANY_INFINITE_WATER) || blockstate.isAir()) {
                    double d0 = vec3.length();
                    if (d0 > 0.0) {
                        vec3.normalize();
                        double d1 = 3.0;
                        if (d0 > 5.0) {
                            d1 -= (d0 - 5.0) / 5.0;
                        }
                        if (d1 > 0.0) {
                            vec3 = vec3.scale(d1);
                        }
                    }
                    if (blockstate.isAir()) {
                        vec3 = vec3.subtract(0.0, vec3.y, 0.0);
                    }
                    this.squid.setMovementVector((float)vec3.x / 20.0f, (float)vec3.y / 20.0f, (float)vec3.z / 20.0f);
                }
                if (this.fleeTicks % 10 == 5) {
                    this.squid.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.squid.getX(), this.squid.getY(), this.squid.getZ(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

