/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.GetHookedGoal;
import net.dries007.tfc.common.entities.ai.TFCFishMoveControl;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class TFCTropicalFish
extends TropicalFish
implements AquaticMob {
    public TFCTropicalFish(EntityType<? extends TropicalFish> type, Level level) {
        super(type, level);
        this.moveControl = new TFCFishMoveControl((PathfinderMob)this);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new GetHookedGoal((PathfinderMob)this));
        EntityHelpers.replaceAvoidEntityGoal((PathfinderMob)this, this.goalSelector, 2);
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, WaterAnimal.class, 8.0f, 5.0, (double)5.4f, e -> Helpers.isEntity((Entity)e, TFCTags.Entities.OCEAN_PREDATORS)));
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)TFCItems.TROPICAL_FISH_BUCKET.get());
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        return EntityHelpers.bucketMobPickup(player, hand, this).orElse(super.mobInteract(player, hand));
    }

    @Override
    public boolean canSpawnIn(Fluid fluid) {
        return fluid.isSame((Fluid)TFCFluids.SALT_WATER.getSource());
    }

    protected float getBlockSpeedFactor() {
        return Helpers.isBlock(this.level().getBlockState(this.blockPosition()), TFCTags.Blocks.ANIMAL_IGNORED_PLANTS) ? 1.0f : super.getBlockSpeedFactor();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return null;
    }
}

