/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import net.dries007.tfc.common.entities.BrainAnimalBehavior;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.CommonAnimalData;
import net.dries007.tfc.common.entities.livestock.ConfigurableAnimalBehavior;
import net.dries007.tfc.common.entities.livestock.Gender;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public interface CommonAnimalBehavior
extends ConfigurableAnimalBehavior,
BrainAnimalBehavior {
    public CommonAnimalData animalData();

    public SynchedEntityData getEntityData();

    public Level level();

    @Override
    default public boolean isMale() {
        return this.getGender().isMale();
    }

    default public boolean isFemale() {
        return this.getGender().isFemale();
    }

    default public Gender getGender() {
        return (Boolean)this.getEntityData().get(this.animalData().gender()) != false ? Gender.MALE : Gender.FEMALE;
    }

    default public void setGender(Gender gender) {
        this.getEntityData().set(this.animalData().gender(), (Object)gender.isMale());
    }

    default public Age getLastAge() {
        return Age.valueOf(((Byte)this.getEntityData().get(this.animalData().lastAge())).byteValue());
    }

    default public void setLastAge(Age age) {
        this.getEntityData().set(this.animalData().lastAge(), (Object)((byte)age.ordinal()));
    }

    default public void addUses(int uses) {
        this.setUses(this.getUses() + uses);
    }

    default public void setUses(int uses) {
        this.getEntityData().set(this.animalData().uses(), (Object)uses);
    }

    default public int getUses() {
        return (Integer)this.getEntityData().get(this.animalData().uses());
    }

    default public boolean isFertilized() {
        return this.getGender().isFemale() && (Boolean)this.getEntityData().get(this.animalData().fertilized()) != false;
    }

    default public void setFertilized(boolean value) {
        if (this.getGender().isFemale()) {
            this.getEntityData().set(this.animalData().fertilized(), (Object)value);
        }
    }

    default public long getBirthTick() {
        return (Long)this.getEntityData().get(this.animalData().birthTick());
    }

    default public void setBirthTickNow() {
        this.setBirthTick(this.calendar().getTicks());
    }

    default public void setBirthTickToALongTimeAgo() {
        this.setBirthTick(this.calendar().getTicks() - 2880000L);
    }

    default public void setBirthTick(long value) {
        this.getEntityData().set(this.animalData().birthTick(), (Object)value);
    }

    default public long getOldTick() {
        return (Long)this.getEntityData().get(this.animalData().oldTick());
    }

    default public void setOldTick(long value) {
        this.getEntityData().set(this.animalData().oldTick(), (Object)value);
    }

    default public void setLastFedYesterday() {
        this.getEntityData().set(this.animalData().lastFedTick(), (Object)(this.calendar().getTicks() - 24000L));
    }

    default public void setLastFedNow() {
        this.getEntityData().set(this.animalData().lastFedTick(), (Object)this.calendar().getTicks());
        this.getEntityData().set(this.animalData().lastFamiliarityTick(), (Object)this.calendar().getTicks());
    }

    default public long getLastFedTick() {
        return (Long)this.getEntityData().get(this.animalData().lastFedTick());
    }

    default public float getFamiliarity() {
        return ((Float)this.getEntityData().get(this.animalData().familiarity())).floatValue();
    }

    default public void setFamiliarity(float value) {
        this.getEntityData().set(this.animalData().familiarity(), (Object)Float.valueOf(Mth.clamp((float)value, (float)0.0f, (float)1.0f)));
        this.getEntityData().set(this.animalData().lastFamiliarityTick(), (Object)this.calendar().getTicks());
    }

    default public long getLastFamiliarityTick() {
        return (Long)this.getEntityData().get(this.animalData().lastFamiliarityTick());
    }

    @Override
    default public void setLastMatedNow() {
        this.getEntityData().set(this.animalData().lastMateTick(), (Object)this.calendar().getTicks());
    }

    default public long getLastMateTick() {
        return (Long)this.getEntityData().get(this.animalData().lastMateTick());
    }

    default public ICalendar calendar() {
        return Calendars.get((LevelReader)this.level());
    }
}

