/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.Temptable;
import net.dries007.tfc.common.entities.ai.TFCGroundPathNavigation;
import net.dries007.tfc.common.entities.ai.livestock.LivestockAi;
import net.dries007.tfc.common.entities.ai.prey.PreyAi;
import net.dries007.tfc.common.entities.livestock.Age;
import net.dries007.tfc.common.entities.livestock.CommonAnimalData;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.animals.AnimalConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class TFCAnimal
extends Animal
implements TFCAnimalProperties,
Temptable {
    private static final CommonAnimalData ANIMAL_DATA = CommonAnimalData.create(TFCAnimal.class);
    private final Supplier<? extends SoundEvent> ambient;
    private final Supplier<? extends SoundEvent> hurt;
    private final Supplier<? extends SoundEvent> death;
    private final Supplier<? extends SoundEvent> step;
    private final AnimalConfig config;

    public TFCAnimal(EntityType<? extends Animal> type, Level level, TFCSounds.EntityId sounds, AnimalConfig config) {
        super(type, level);
        this.getNavigation().setCanFloat(true);
        this.ambient = sounds.ambient();
        this.hurt = sounds.hurt();
        this.death = sounds.death();
        this.step = sounds.step();
        this.config = config;
    }

    protected Brain.Provider<? extends TFCAnimal> brainProvider() {
        return Brain.provider(LivestockAi.MEMORY_TYPES, LivestockAi.SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return LivestockAi.makeBrain((Brain<? extends TFCAnimal>)this.brainProvider().makeBrain(dynamic));
    }

    public boolean hurt(DamageSource src, float amount) {
        Entity entity;
        boolean hurt = super.hurt(src, amount);
        if (this.level().isClientSide) {
            return hurt;
        }
        if (hurt && (entity = src.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PreyAi.wasHurtBy((LivingEntity)this, living);
        }
        return hurt;
    }

    public Brain<? extends TFCAnimal> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.tickBrain();
    }

    public void tickBrain() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        LivestockAi.updateActivity(this);
    }

    @Override
    public CommonAnimalData animalData() {
        return ANIMAL_DATA;
    }

    @Override
    public AnimalConfig animalConfig() {
        return this.config;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.animalData().define(builder);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.saveCommonAnimalData(nbt);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readCommonAnimalData(nbt);
    }

    public boolean isBaby() {
        return this.getAgeType() == Age.CHILD;
    }

    public void setAge(int age) {
        super.setAge(0);
    }

    public int getAge() {
        return this.isBaby() ? -24000 : 0;
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob other) {
        return TFCAnimalProperties.super.getBreedOffspring(level, other);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData) {
        if (spawnType != MobSpawnType.BREEDING) {
            this.initCommonAnimalData(level, difficulty, spawnType);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnData);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (ANIMAL_DATA.birthTick().equals(data)) {
            this.refreshDimensions();
        }
    }

    public void tick() {
        super.tick();
        if (this.level().getGameTime() % 20L == 0L) {
            this.tickAnimalData();
        }
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result = TFCAnimalProperties.super.mobInteract(player, hand);
        return result == InteractionResult.PASS ? super.mobInteract(player, hand) : result;
    }

    public boolean canMate(Animal otherAnimal) {
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        TFCAnimal other = (TFCAnimal)otherAnimal;
        return this.getGender() != other.getGender() && this.isReadyToMate() && other.isReadyToMate();
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return TFCAnimalProperties.super.isFood(stack);
    }

    public Component getTypeName() {
        return this.getGenderedTypeName();
    }

    protected SoundEvent getAmbientSound() {
        return this.ambient.get();
    }

    protected SoundEvent getHurtSound(DamageSource src) {
        return this.hurt.get();
    }

    protected SoundEvent getDeathSound() {
        return this.death.get();
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
        this.playSound(this.step.get(), 0.15f, 1.0f);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return Helpers.isBlock(level.getBlockState(pos.below()), TFCTags.Blocks.BUSH_PLANTABLE_ON) ? 10.0f : level.getPathfindingCostFromLightLevels(pos);
    }

    public PathNavigation createNavigation(Level level) {
        return new TFCGroundPathNavigation((Mob)this, level);
    }

    public boolean isInWall() {
        return !this.level().isClientSide && super.isInWall();
    }

    protected void pushEntities() {
        if (!this.level().isClientSide) {
            super.pushEntities();
        }
    }
}

