/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.pet;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.pet.TamableMammal;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class Dog
extends TamableMammal {
    private float interestedAngle;
    private float interestedAngleO;

    public Dog(EntityType<? extends TFCAnimal> animal, Level level) {
        super(animal, level, TFCSounds.DOG, TFCConfig.SERVER.dogConfig);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isAlive()) {
            this.interestedAngleO = this.interestedAngle;
            this.interestedAngle += 0.4f * (this.isInterested() ? 1.0f - this.interestedAngle : 0.0f - this.interestedAngle);
        }
    }

    public float getHeadRollAngle(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    @Override
    public TagKey<Item> getFoodTag() {
        return TFCTags.Items.DOG_FOOD;
    }

    @Override
    public boolean canAttack(LivingEntity entity) {
        return super.canAttack(entity) && (Helpers.isEntity((Entity)entity, TFCTags.Entities.HUNTED_BY_DOGS) || entity instanceof Monster);
    }
}

