/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.pet;

import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.PredicateMoveControl;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.pet.TamableAi;
import net.dries007.tfc.common.entities.livestock.Mammal;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.animals.MammalConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class TamableMammal
extends Mammal
implements OwnableEntity {
    public static final EntityDataAccessor<Optional<UUID>> DATA_OWNER = SynchedEntityData.defineId(TamableMammal.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Byte> DATA_PET_FLAGS = SynchedEntityData.defineId(TamableMammal.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.defineId(TamableMammal.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState sleepingAnimation = new AnimationState();
    public final AnimationState sittingAnimation = new AnimationState();
    private static final int SLEEPING_FLAG = 1;
    private static final int SITTING_FLAG = 4;
    private static final int INTERESTED_FLAG = 8;
    private static final int UNUSED_FLAG_2 = 16;
    private final Supplier<SoundEvent> sleeping;
    private Command command = Command.RELAX;
    private boolean needsCommandUpdate = false;

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public TamableMammal(EntityType<? extends TFCAnimal> animal, Level level, TFCSounds.EntityId sounds, MammalConfig config) {
        super(animal, level, sounds, config);
        this.sleeping = sounds.sleep().orElseThrow();
        this.moveControl = new PredicateMoveControl<TamableMammal>(this, e -> !e.isSitting() && !e.isSleeping());
    }

    protected Brain.Provider<? extends TamableMammal> brainProvider() {
        return Brain.provider(TamableAi.MEMORY_TYPES, TamableAi.SENSOR_TYPES);
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return TamableAi.makeBrain((Brain<? extends TamableMammal>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<? extends TamableMammal> getBrain() {
        return super.getBrain();
    }

    @Override
    public void tickBrain() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        TamableAi.updateActivity(this, this.tickCount % 20 == 0);
    }

    @Override
    public void createGenes(CompoundTag tag, TFCAnimalProperties male) {
        super.createGenes(tag, male);
        if (this.getOwnerUUID() != null) {
            tag.putUUID("owner", this.getOwnerUUID());
        }
    }

    @Override
    public void applyGenes(CompoundTag tag, MammalProperties baby) {
        super.applyGenes(tag, baby);
        if (baby instanceof TamableMammal) {
            TamableMammal tamable = (TamableMammal)baby;
            if (tag.hasUUID("owner")) {
                tamable.setOwnerUUID(tag.getUUID("owner"));
            }
        }
    }

    @Override
    public void tick() {
        if (this.level().isClientSide) {
            EntityHelpers.startOrStop(this.sittingAnimation, this.isSitting(), this.tickCount);
            EntityHelpers.startOrStop(this.sleepingAnimation, this.isSleeping(), this.tickCount);
            if (this.isSleeping() && this.getRandom().nextInt(10) == 0) {
                this.level().addParticle((ParticleOptions)TFCParticles.SLEEP.get(), this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ(), 0.01, 0.05, 0.01);
            }
        }
        super.tick();
        if (this.needsCommandUpdate && this.command.activity != null) {
            this.getBrain().setActiveActivityIfPossible(this.command.activity.get());
            this.needsCommandUpdate = false;
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_OWNER, Optional.empty());
        builder.define(DATA_PET_FLAGS, (Object)0);
        builder.define(DATA_COLLAR_COLOR, (Object)DyeColor.WHITE.getId());
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor color) {
        this.entityData.set(DATA_COLLAR_COLOR, (Object)color.getId());
    }

    public boolean willListenTo(Command command, boolean isClientSide) {
        return command != Command.SIT || this.getHealth() >= 5.0f;
    }

    public void receiveCommand(ServerPlayer player, Command command) {
        if (this.isOwnedBy((Entity)player)) {
            switch (command.ordinal()) {
                case 0: {
                    this.setSitting(false);
                    this.setSleeping(false);
                    break;
                }
                case 2: {
                    this.setSitting(true);
                    this.setSleeping(false);
                    this.getBrain().setMemory((MemoryModuleType)TFCBrain.SIT_TIME.get(), (Object)Calendars.SERVER.getTicks());
                    this.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
                    this.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
                    break;
                }
                case 1: {
                    this.getBrain().setMemory(MemoryModuleType.HOME, (Object)GlobalPos.of((ResourceKey)this.level().dimension(), (BlockPos)player.blockPosition()));
                    command = Command.RELAX;
                    break;
                }
                case 3: 
                case 4: {
                    this.setSitting(false);
                    this.setSleeping(false);
                    this.getBrain().eraseMemory((MemoryModuleType)TFCBrain.SIT_TIME.get());
                }
            }
            this.command = command;
            Activity commandedActivity = Command.getActivity(command);
            if (commandedActivity != null) {
                this.getBrain().setActiveActivityIfPossible(commandedActivity);
            }
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"tfc.pet.not_owner"), true);
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public void refreshCommandOnNextTick() {
        this.needsCommandUpdate = true;
    }

    public boolean isSleeping() {
        return ((Byte)this.entityData.get(DATA_PET_FLAGS) & 1) != 0;
    }

    public void setSleeping(boolean sleep) {
        this.entityData.set(DATA_PET_FLAGS, (Object)this.setBit((Byte)this.entityData.get(DATA_PET_FLAGS), 1, sleep));
    }

    public boolean isSitting() {
        return ((Byte)this.entityData.get(DATA_PET_FLAGS) & 4) != 0;
    }

    public void setSitting(boolean sitting) {
        this.entityData.set(DATA_PET_FLAGS, (Object)this.setBit((Byte)this.entityData.get(DATA_PET_FLAGS), 4, sitting));
    }

    public boolean isInterested() {
        return ((Byte)this.entityData.get(DATA_PET_FLAGS) & 8) != 0;
    }

    public void setInterested(boolean interested) {
        this.entityData.set(DATA_PET_FLAGS, (Object)this.setBit((Byte)this.entityData.get(DATA_PET_FLAGS), 8, interested));
    }

    private byte setBit(byte oldBit, int offset, boolean value) {
        return (byte)(value ? oldBit | offset : oldBit & ~offset);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(DATA_OWNER)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID id) {
        this.entityData.set(DATA_OWNER, Optional.ofNullable(id));
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.level().getPlayerByUUID(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        DyeItem dye;
        DyeColor color;
        ItemStack held = player.getItemInHand(hand);
        Item item = held.getItem();
        if (item instanceof DyeItem && (color = (dye = (DyeItem)item).getDyeColor()) != this.getCollarColor()) {
            this.setCollarColor(color);
            if (!player.getAbilities().instabuild) {
                held.shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (held.isEmpty() && player.isShiftKeyDown() && this.getOwner() != null && this.isOwnedBy((Entity)player) && !this.isOnFire()) {
            if (this.level().isClientSide) {
                ClientHelpers.openPetScreen(this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.getFamiliarity() + 0.06f > 0.15f && this.getOwnerUUID() == null && this.isFood(held) && this.isHungry()) {
            this.tame(player);
        }
        return super.mobInteract(player, hand);
    }

    public void spawnTamingParticles(ParticleOptions particle) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(particle, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 7, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, 1.0);
        }
    }

    public void tame(Player player) {
        this.setOwnerUUID(player.getUUID());
        this.spawnTamingParticles((ParticleOptions)ParticleTypes.HEART);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.TAME_ANIMAL.trigger(serverPlayer, (Animal)this);
        }
    }

    public boolean canAttack(LivingEntity target) {
        return !this.isOwnedBy((Entity)target) && super.canAttack(target);
    }

    public boolean isOwnedBy(@Nullable Entity entity) {
        return entity != null && entity.equals((Object)this.getOwner());
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.getOwnerUUID() != null) {
            tag.putUUID("Owner", this.getOwnerUUID());
        }
        tag.putInt("command", this.command.ordinal());
        tag.putByte("petFlags", ((Byte)this.entityData.get(DATA_PET_FLAGS)).byteValue());
        tag.putInt("CollarColor", this.getCollarColor().getId());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.hasUUID("Owner")) {
            this.setOwnerUUID(tag.getUUID("Owner"));
        }
        this.command = Command.valueOf(tag.getInt("command"));
        this.entityData.set(DATA_PET_FLAGS, (Object)tag.getByte("petFlags"));
        this.setCollarColor(DyeColor.byId((int)tag.getInt("CollarColor")));
        this.refreshCommandOnNextTick();
    }

    public void die(DamageSource source) {
        LivingEntity livingEntity;
        Component deathMessage = this.getCombatTracker().getDeathMessage();
        super.die(source);
        if (this.dead && (livingEntity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES)) {
                serverPlayer.sendSystemMessage(deathMessage);
            }
        }
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return this.isSleeping() ? this.sleeping.get() : super.getAmbientSound();
    }

    public static enum Command {
        RELAX((Supplier<Activity>)TFCBrain.IDLE_AT_HOME),
        HOME(null),
        SIT((Supplier<Activity>)TFCBrain.SIT),
        FOLLOW((Supplier<Activity>)TFCBrain.FOLLOW),
        HUNT((Supplier<Activity>)TFCBrain.HUNT);

        public static final Command[] VALUES;
        public static final StreamCodec<ByteBuf, Command> STREAM;
        @Nullable
        private final Supplier<Activity> activity;

        public static Command valueOf(int id) {
            return VALUES[id];
        }

        @Nullable
        public static Activity getActivity(Command command) {
            return command.activity == null ? null : command.activity.get();
        }

        private Command(Supplier<Activity> activity) {
            this.activity = activity;
        }

        static {
            VALUES = Command.values();
            STREAM = ByteBufCodecs.BYTE.map(Command::valueOf, c -> (byte)c.ordinal());
        }
    }
}

