/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.misc;

import net.dries007.tfc.common.effect.TFCEffects;
import net.dries007.tfc.common.entities.IGlow;
import net.dries007.tfc.common.entities.TFCEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import org.jetbrains.annotations.Nullable;

public class GlowArrow
extends AbstractArrow
implements IGlow {
    public static final EntityDataAccessor<BlockPos> DATA_LIGHT_POS = SynchedEntityData.defineId(GlowArrow.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);

    public GlowArrow(Level level, LivingEntity shooter, @Nullable ItemStack weapon) {
        super((EntityType)TFCEntities.GLOW_ARROW.get(), shooter, level, new ItemStack((ItemLike)Items.ARROW), weapon);
    }

    public GlowArrow(EntityType<? extends AbstractArrow> entity, Level level) {
        super(entity, level);
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.addEffect(new MobEffectInstance(TFCEffects.GLOW_INK.holder(), 200, 0), this.getEffectSource());
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.saveLight(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readLight(tag);
    }

    public void remove(Entity.RemovalReason reason) {
        this.tryRemoveLight();
        super.remove(reason);
    }

    @Nullable
    public Entity changeDimension(DimensionTransition transition) {
        this.tryRemoveLight();
        return super.changeDimension(transition);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_LIGHT_POS, (Object)BlockPos.ZERO);
    }

    @Override
    public void setLightPos(BlockPos pos) {
        this.entityData.set(DATA_LIGHT_POS, (Object)pos);
    }

    @Override
    public BlockPos getLightPos() {
        return (BlockPos)this.entityData.get(DATA_LIGHT_POS);
    }

    @Override
    public int getLightUpdateDistanceSqr() {
        return 4;
    }

    @Override
    public int getLightUpdateInterval() {
        return this.getDeltaMovement().lengthSqr() < 0.01 ? 20 : 5;
    }

    public void tick() {
        super.tick();
        IGlow.super.tickGlow();
        if (this.level().isClientSide && !this.inGround) {
            this.level().addParticle((ParticleOptions)ParticleTypes.GLOW_SQUID_INK, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public ItemStack getPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

