/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.misc;

import java.util.List;
import net.dries007.tfc.common.entities.TFCEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Seat
extends Entity {
    private static final Vec3 ATTACHMENT_POINT = new Vec3(0.0, -0.25, 0.0);

    public static void sit(Level level, BlockPos pos, Entity sitter) {
        if (!level.isClientSide) {
            Seat seat = (Seat)((EntityType)TFCEntities.SEAT.get()).create(level);
            assert (seat != null);
            seat.moveTo(pos, 0.0f, 0.0f);
            level.addFreshEntity((Entity)seat);
            sitter.startRiding((Entity)seat);
        }
    }

    @Nullable
    public static Entity getSittingEntity(Level level, BlockPos pos) {
        List passengers;
        List entities = level.getEntitiesOfClass(Seat.class, new AABB(pos));
        if (!entities.isEmpty() && !(passengers = ((Seat)((Object)entities.get(0))).getPassengers()).isEmpty()) {
            return (Entity)passengers.get(0);
        }
        return null;
    }

    public Seat(EntityType<?> type, Level level) {
        super(type, level);
        this.noPhysics = true;
    }

    public void tick() {
        super.tick();
        if (!this.isVehicle()) {
            this.setRemoved(Entity.RemovalReason.DISCARDED);
        }
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return ATTACHMENT_POINT;
    }

    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }
}

