/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.misc;

import net.dries007.tfc.common.blockentities.TFCChestBlockEntity;
import net.dries007.tfc.common.container.RestrictedChestContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TFCMinecartChest
extends MinecartChest {
    public static final EntityDataAccessor<ItemStack> DATA_CART_ITEM = SynchedEntityData.defineId(TFCMinecartChest.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<ItemStack> DATA_CHEST_ITEM = SynchedEntityData.defineId(TFCMinecartChest.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public TFCMinecartChest(EntityType<? extends MinecartChest> entityType, Level level) {
        super(entityType, level);
    }

    public int getContainerSize() {
        return 18;
    }

    public SlotAccess getSlot(final int index) {
        return index >= 0 && index < this.getContainerSize() ? new SlotAccess(){

            public ItemStack get() {
                return TFCMinecartChest.this.getItem(index);
            }

            public boolean set(ItemStack stack) {
                if (!TFCChestBlockEntity.isValid(stack)) {
                    return false;
                }
                TFCMinecartChest.this.setItem(index, stack);
                return true;
            }
        } : SlotAccess.NULL;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("cartItem", this.getPickResult().save((HolderLookup.Provider)this.registryAccess()));
        tag.put("chestItem", this.getChestItem().save((HolderLookup.Provider)this.registryAccess()));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setPickResult(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound("cartItem")));
        this.setChestItem(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound("chestItem")));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CHEST_ITEM, (Object)ItemStack.EMPTY);
        builder.define(DATA_CART_ITEM, (Object)ItemStack.EMPTY);
    }

    public ItemStack getChestItem() {
        return (ItemStack)this.entityData.get(DATA_CHEST_ITEM);
    }

    public void setChestItem(ItemStack item) {
        this.entityData.set(DATA_CHEST_ITEM, (Object)item.copy());
    }

    public void setPickResult(ItemStack item) {
        this.entityData.set(DATA_CART_ITEM, (Object)item.copy());
    }

    @NotNull
    public ItemStack getPickResult() {
        return ((ItemStack)this.entityData.get(DATA_CART_ITEM)).copy();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory) {
        return new RestrictedChestContainer((MenuType)TFCContainerTypes.CHEST_9x2.get(), windowId, inventory, (Container)this, 2);
    }

    public BlockState getDisplayBlockState() {
        BlockState blockState;
        Item item = this.getChestItem().getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            blockState = blockItem.getBlock().defaultBlockState();
        } else {
            blockState = Blocks.AIR.defaultBlockState();
        }
        return blockState;
    }

    public boolean hasCustomDisplay() {
        return true;
    }

    protected Item getDropItem() {
        return this.getPickResult().getItem();
    }
}

