/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.predator;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.entities.ai.TFCClimberNavigation;
import net.dries007.tfc.common.entities.predator.Predator;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;

public class FelinePredator
extends Predator {
    public final double crouchSpeedMod;
    public final double sprintSpeedMod;
    public final double attackDistanceSquared;
    public static final EntityDataAccessor<Boolean> DATA_CLIMBING = SynchedEntityData.defineId(FelinePredator.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public static FelinePredator createCougar(EntityType<? extends Predator> type, Level level) {
        return new FelinePredator(type, level, false, 36.0, 0.8, 1.5, TFCSounds.COUGAR);
    }

    public static FelinePredator createLion(EntityType<? extends Predator> type, Level level) {
        return new FelinePredator(type, level, false, 36.0, 0.8, 1.5, TFCSounds.LION);
    }

    public static FelinePredator createSabertooth(EntityType<? extends Predator> type, Level level) {
        return new FelinePredator(type, level, false, 36.0, 0.8, 1.5, TFCSounds.SABERTOOTH);
    }

    public static FelinePredator createTiger(EntityType<? extends Predator> type, Level level) {
        return new FelinePredator(type, level, false, 36.0, 0.8, 1.5, TFCSounds.TIGER);
    }

    public FelinePredator(EntityType<? extends Predator> type, Level level, boolean diurnal, double attackDistanceSquared, double crouchSpeedMod, double sprintSpeedMod, TFCSounds.EntityId sounds) {
        super(type, level, diurnal, sounds);
        this.crouchSpeedMod = crouchSpeedMod;
        this.sprintSpeedMod = sprintSpeedMod;
        this.attackDistanceSquared = attackDistanceSquared;
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CLIMBING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.25).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setClimbing(this.horizontalCollision);
        }
    }

    @Override
    public void tickAnimationStates() {
        if (this.isSleeping()) {
            if (this.getRandom().nextInt(10) == 0) {
                this.level().addParticle((ParticleOptions)TFCParticles.SLEEP.get(), this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ(), 0.01, 0.05, 0.01);
            }
            this.sleepingAnimation.startIfStopped(this.tickCount);
        } else {
            this.sleepingAnimation.stop();
        }
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        return new TFCClimberNavigation((Mob)this, level);
    }

    public void setClimbing(boolean climbing) {
        this.entityData.set(DATA_CLIMBING, (Object)climbing);
    }

    public boolean isClimbing() {
        return (Boolean)this.entityData.get(DATA_CLIMBING);
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }
}

