/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import com.mojang.serialization.Dynamic;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.prey.PreyAi;
import net.dries007.tfc.common.entities.prey.WildAnimal;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class Prey
extends WildAnimal {
    public final AnimationState walkingAnimation = new AnimationState();

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public static AttributeSupplier.Builder createLargeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public Prey(EntityType<? extends WildAnimal> type, Level level, TFCSounds.EntityId sounds) {
        super(type, level, sounds);
    }

    protected Brain.Provider<? extends Prey> brainProvider() {
        return Brain.provider(PreyAi.MEMORY_TYPES, PreyAi.SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return PreyAi.makeBrain((Brain<? extends Prey>)this.brainProvider().makeBrain(dynamic));
    }

    protected void customServerAiStep() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        PreyAi.updateActivity(this);
    }

    public Brain<Prey> getBrain() {
        return super.getBrain();
    }

    public boolean hurt(DamageSource src, float amount) {
        Entity entity;
        boolean hurt = super.hurt(src, amount);
        if (this.level().isClientSide) {
            return false;
        }
        if (hurt && (entity = src.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PreyAi.wasHurtBy((LivingEntity)this, living);
        }
        return hurt;
    }

    @Override
    public void tick() {
        if (this.level().isClientSide) {
            EntityHelpers.startOrStop(this.walkingAnimation, EntityHelpers.isMovingOnLand((Entity)this), this.tickCount);
        }
        super.tick();
    }
}

