/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import com.google.common.base.Suppliers;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dries007.tfc.common.fluids.FluidHolder;
import net.dries007.tfc.util.registry.IdHolder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FluidProperty
extends Property<FluidKey> {
    private final Map<String, FluidKey> keysById;
    private final Map<Fluid, FluidKey> keysByFluid = new HashMap<Fluid, FluidKey>();
    private final List<FluidKey> keysByIndex;
    private final Supplier<Set<Fluid>> fluids;

    public static FluidProperty create(String name, Stream<Object> fluids) {
        return new FluidProperty(name, fluids.map(obj -> {
            Object object = obj;
            Objects.requireNonNull(object);
            Object selector0$temp = object;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ResourceLocation.class, Fluid.class, IdHolder.class, FluidHolder.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    ResourceLocation id;
                    yield id = (ResourceLocation)selector0$temp;
                }
                case 1 -> {
                    Fluid fluid = (Fluid)selector0$temp;
                    yield BuiltInRegistries.FLUID.getKey((Object)fluid);
                }
                case 2 -> {
                    IdHolder reg = (IdHolder)selector0$temp;
                    yield reg.getId();
                }
                case 3 -> {
                    FluidHolder pair = (FluidHolder)selector0$temp;
                    yield pair.source().getId();
                }
                default -> throw new IllegalArgumentException("FluidProperty#create called with a weird thing: " + String.valueOf(obj));
            };
        }));
    }

    protected FluidProperty(String name, Stream<ResourceLocation> fluids) {
        super(name, FluidKey.class);
        this.keysById = new HashMap<String, FluidKey>();
        this.keysByIndex = new ArrayList<FluidKey>();
        fluids.sorted().forEach(id -> {
            assert (!this.keysById.containsKey(id.getPath())) : "Duplicate fluid key: " + id.getPath();
            FluidKey key = new FluidKey((ResourceLocation)id);
            this.keysById.put(id.getPath(), key);
            this.keysByIndex.add(key);
        });
        this.fluids = Suppliers.memoize(() -> this.keysByIndex.stream().map(FluidKey::getFluid).collect(Collectors.toSet()));
    }

    public boolean canContain(Fluid fluid) {
        return this.fluids.get().contains(fluid);
    }

    public FluidKey keyForOrEmpty(Fluid fluid) {
        return this.canContain(fluid) ? this.keyFor(fluid) : this.keyFor(Fluids.EMPTY);
    }

    public FluidKey keyFor(Fluid fluid) {
        FluidKey key = this.keysByFluid.get(fluid);
        if (key != null) {
            return key;
        }
        key = this.keysById.get(Objects.requireNonNull(BuiltInRegistries.FLUID.getKey((Object)fluid)).getPath());
        if (key == null) {
            throw new IllegalArgumentException("Tried to get the FluidKey for a fluid [" + String.valueOf(BuiltInRegistries.FLUID.getKey((Object)fluid)) + "] which was not present in property " + this.getName() + " / " + String.valueOf(this.getPossibleValues()));
        }
        this.keysByFluid.put(fluid, key);
        return key;
    }

    public Collection<FluidKey> getPossibleValues() {
        return this.keysByIndex;
    }

    public String getName(FluidKey value) {
        return value.name.getPath();
    }

    public Optional<FluidKey> getValue(String value) {
        return Optional.ofNullable(this.keysById.get(value));
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int generateHashCode() {
        return System.identityHashCode((Object)this);
    }

    public static class FluidKey
    implements Comparable<FluidKey> {
        private final ResourceLocation name;
        private final DeferredHolder<Fluid, ? extends Fluid> fluid;

        private FluidKey(ResourceLocation name) {
            this.name = name;
            this.fluid = DeferredHolder.create((ResourceKey)Registries.FLUID, (ResourceLocation)name);
        }

        public Fluid getFluid() {
            return (Fluid)this.fluid.get();
        }

        public boolean is(Fluid other) {
            return this.fluid.get() == other;
        }

        public boolean is(FluidKey other) {
            return this.name.equals((Object)other.name);
        }

        @Override
        public int compareTo(FluidKey other) {
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return "FluidKey[" + String.valueOf(this.name) + "]";
        }
    }
}

