/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import net.dries007.tfc.common.fluids.FluidProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public interface IFluidLoggable
extends SimpleWaterloggedBlock,
LiquidBlockContainer,
BucketPickup {
    default public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        Fluid containedFluid = ((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid();
        if (containedFluid == Fluids.EMPTY) {
            return this.getFluidProperty().canContain(fluid);
        }
        return false;
    }

    default public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        Fluid containedFluid = ((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid();
        if (containedFluid == Fluids.EMPTY && this.getFluidProperty().canContain(fluidStateIn.getType())) {
            if (!level.isClientSide()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidStateIn.getType())), 3);
                level.scheduleTick(pos, fluidStateIn.getType(), fluidStateIn.getType().getTickDelay((LevelReader)level));
            }
            return true;
        }
        return false;
    }

    default public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        Fluid containedFluid = ((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid();
        if (containedFluid != Fluids.EMPTY) {
            level.setBlock(pos, (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.EMPTY)), 3);
            return containedFluid.getFluidType().getBucket(new FluidStack(containedFluid, 1000));
        }
        return ItemStack.EMPTY;
    }

    default public FluidState getFluidState(BlockState state) {
        Fluid containedFluid = ((FluidProperty.FluidKey)state.getValue((Property)this.getFluidProperty())).getFluid();
        if (containedFluid instanceof FlowingFluid) {
            FlowingFluid flowingFluid = (FlowingFluid)containedFluid;
            return flowingFluid.getSource(false);
        }
        return containedFluid.defaultFluidState();
    }

    public FluidProperty getFluidProperty();
}

