/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import java.util.Map;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.mixin.accessor.FlowingFluidAccessor;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import org.jetbrains.annotations.Nullable;

public abstract class MixingFluid
extends BaseFlowingFluid {
    protected MixingFluid(BaseFlowingFluid.Properties properties) {
        super(properties);
    }

    public int sourceNeighborCount(LevelReader worldIn, BlockPos pos) {
        int adjacentSources = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos = pos.relative(direction);
            FluidState adjacentFluid = worldIn.getFluidState(adjacentPos);
            if (!this.isSourceBlockOfThisType(adjacentFluid)) continue;
            ++adjacentSources;
        }
        return adjacentSources;
    }

    public boolean isSourceBlockOfThisType(FluidState stateIn) {
        return stateIn.getType().isSame((Fluid)this) && stateIn.isSource();
    }

    public boolean isSame(Fluid fluid) {
        return super.isSame(fluid) || Helpers.isFluid(fluid, TFCTags.Fluids.ANY_INFINITE_WATER);
    }

    public void spreadToSides(Level level, BlockPos pos, FluidState sourceFluid, BlockState sourceState) {
        int adjacentAmount = sourceFluid.getAmount() - this.getDropOff((LevelReader)level);
        if (((Boolean)sourceFluid.getValue((Property)FALLING)).booleanValue()) {
            adjacentAmount = 7;
        }
        if (adjacentAmount > 0) {
            Map map = this.getSpread(level, pos, sourceState);
            for (Map.Entry entry : map.entrySet()) {
                BlockState destState;
                Direction direction = (Direction)entry.getKey();
                FluidState spreadFluid = (FluidState)entry.getValue();
                BlockPos destPos = pos.relative(direction);
                if (!this.canSpreadTo((BlockGetter)level, pos, sourceState, direction, destPos, destState = level.getBlockState(destPos), level.getFluidState(destPos), spreadFluid.getType())) continue;
                this.spreadTo((LevelAccessor)level, destPos, destState, direction, spreadFluid);
            }
        }
    }

    protected void spread(Level level, BlockPos pos, FluidState stateIn) {
        if (!stateIn.isEmpty()) {
            BlockState blockStateAt = level.getBlockState(pos);
            BlockPos posBelow = pos.below();
            BlockState blockStateBelow = level.getBlockState(posBelow);
            FluidState fluidstate = this.getNewLiquid(level, posBelow, blockStateBelow);
            if (this.canSpreadTo((BlockGetter)level, pos, blockStateAt, Direction.DOWN, posBelow, blockStateBelow, level.getFluidState(posBelow), fluidstate.getType())) {
                this.spreadTo((LevelAccessor)level, posBelow, blockStateBelow, Direction.DOWN, fluidstate);
                if (this.sourceNeighborCount((LevelReader)level, pos) >= 3) {
                    this.spreadToSides(level, pos, stateIn, blockStateAt);
                }
            } else if (stateIn.isSource() || !((FlowingFluidAccessor)((Object)this)).invoke$isWaterHole((BlockGetter)level, fluidstate.getType(), pos, blockStateAt, posBelow, blockStateBelow)) {
                this.spreadToSides(level, pos, stateIn, blockStateAt);
            }
        }
    }

    protected FluidState getNewLiquid(Level level, BlockPos pos, BlockState blockStateIn) {
        return FluidHelpers.getNewFluidWithMixing((FlowingFluid)this, level, pos, blockStateIn, this.getDropOff((LevelReader)level));
    }

    public void tick(Level level, BlockPos pos, FluidState state) {
        if (!state.isSource()) {
            FluidState fluidAt = this.getNewLiquid(level, pos, level.getBlockState(pos));
            int spreadDelay = this.getSpreadDelay(level, pos, state, fluidAt);
            if (fluidAt.isEmpty()) {
                state = fluidAt;
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            } else if (!fluidAt.equals(state)) {
                state = fluidAt;
                BlockState blockstate = fluidAt.createLegacyBlock();
                level.setBlock(pos, blockstate, 2);
                level.scheduleTick(pos, fluidAt.getType(), spreadDelay);
                level.updateNeighborsAt(pos, blockstate.getBlock());
            }
        }
        this.spread(level, pos, state);
    }

    public void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
        if (!state.isSource() && !((Boolean)state.getValue((Property)FALLING)).booleanValue()) {
            if (random.nextInt(64) == 0) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        } else if (random.nextInt(10) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.UNDERWATER, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_WATER;
    }

    public static class Source
    extends MixingFluid {
        public Source(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean isSource(FluidState state) {
            return true;
        }

        public int getAmount(FluidState state) {
            return 8;
        }
    }

    public static class Flowing
    extends MixingFluid {
        public Flowing(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean isSource(FluidState state) {
            return false;
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder.add(new Property[]{LEVEL}));
        }
    }
}

