/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface PlantableInfo {
    public static void addTooltipInfo(ItemStack stack, Consumer<Component> tooltip) {
        Item item = stack.getItem();
        if (item instanceof PlantableInfo) {
            boolean addLifecycleInfo;
            PlantNutrients nutrients;
            PlantableInfo plantable = (PlantableInfo)item;
            if (!ClientHelpers.hasShiftDown()) {
                tooltip.accept((Component)Component.translatable((String)"tfc.tooltip.plantable.hold_shift").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                return;
            }
            boolean addedText = false;
            ClimateRange climate = plantable.getClimateRangeInfo();
            if (climate != null) {
                tooltip.accept((Component)Component.translatable((String)"tfc.tooltip.plantable.climate").withStyle(ChatFormatting.GRAY));
                tooltip.accept(PlantableInfo.indent((Component)Component.translatable((String)"tfc.tooltip.plantable.climate.temperature", (Object[])new Object[]{Float.valueOf(climate.minTemperature()), Float.valueOf(climate.maxTemperature())}), 1));
                tooltip.accept(PlantableInfo.indent((Component)Component.translatable((String)"tfc.tooltip.plantable.climate.hydration", (Object[])new Object[]{climate.minHydration(), climate.maxHydration()}), 1));
                addedText = true;
            }
            if ((nutrients = plantable.getNutrientsInfo()) != null) {
                if (addedText) {
                    tooltip.accept((Component)Component.empty());
                }
                float n = nutrients.nitrogen();
                float p = nutrients.phosphorus();
                float k = nutrients.potassium();
                boolean consumesNutrients = n > 0.0f || p > 0.0f || k > 0.0f;
                tooltip.accept((Component)Component.translatable((String)"tfc.tooltip.plantable.nutrients").withStyle(ChatFormatting.GRAY));
                tooltip.accept(PlantableInfo.indent((Component)Component.translatable((String)"tfc.tooltip.fertilizer.nitrogen", (Object[])new Object[]{PlantableInfo.formatNutrientAmount(n, consumesNutrients)}), 1));
                tooltip.accept(PlantableInfo.indent((Component)Component.translatable((String)"tfc.tooltip.fertilizer.phosphorus", (Object[])new Object[]{PlantableInfo.formatNutrientAmount(p, consumesNutrients)}), 1));
                tooltip.accept(PlantableInfo.indent((Component)Component.translatable((String)"tfc.tooltip.fertilizer.potassium", (Object[])new Object[]{PlantableInfo.formatNutrientAmount(k, consumesNutrients)}), 1));
                addedText = true;
            }
            List<Lifecycle> lifecycle = plantable.getLifecycleInfo();
            int growTicks = plantable.getGrowthTimeInfo();
            boolean addGrowInfo = growTicks > 0;
            boolean bl = addLifecycleInfo = lifecycle != null;
            if (addGrowInfo || addLifecycleInfo) {
                if (addedText) {
                    tooltip.accept((Component)Component.empty());
                }
                tooltip.accept((Component)Component.translatable((String)"tfc.tooltip.plantable.lifecycle").withStyle(ChatFormatting.GRAY));
            }
            if (addGrowInfo) {
                tooltip.accept(PlantableInfo.indent((Component)Component.translatable((String)"tfc.tooltip.plantable.lifecycle.growth_speed").withStyle(ChatFormatting.GREEN).append(" ").append((Component)Calendars.get().getTimeDelta(growTicks).withStyle(ChatFormatting.WHITE)), 1));
            }
            if (addLifecycleInfo) {
                Month growMonth = null;
                Month fruitMonth = null;
                for (int index = Month.DECEMBER.ordinal(); index > Month.JANUARY.ordinal(); --index) {
                    Month month = Month.valueOf(index);
                    Lifecycle stage = lifecycle.get(index);
                    growMonth = PlantableInfo.findStartingMonth(Lifecycle.HEALTHY, stage, growMonth, month);
                    fruitMonth = PlantableInfo.findStartingMonth(Lifecycle.FRUITING, stage, fruitMonth, month);
                }
                if (growMonth != null) {
                    tooltip.accept(PlantableInfo.indent((Component)Component.translatable((String)"tfc.tooltip.plantable.lifecycle.healthy").withColor(6993235).append(" ").append((Component)Component.translatable((String)growMonth.getTranslationKey(Month.Style.SEASON)).withStyle(ChatFormatting.WHITE)), 1));
                }
                if (fruitMonth != null) {
                    tooltip.accept(PlantableInfo.indent((Component)Component.translatable((String)"tfc.tooltip.plantable.lifecycle.fruiting").withColor(10622975).append(" ").append((Component)Component.translatable((String)fruitMonth.getTranslationKey(Month.Style.SEASON)).withStyle(ChatFormatting.WHITE)), 1));
                }
            }
        }
    }

    @Nullable
    private static Month findStartingMonth(Lifecycle targetStage, Lifecycle currentStage, @Nullable Month foundMonth, Month currentMonth) {
        if (currentStage == targetStage) {
            if (foundMonth == null) {
                return currentMonth;
            }
            if (currentMonth.next().equals((Object)foundMonth)) {
                return currentMonth;
            }
        }
        return foundMonth;
    }

    private static Component indent(Component component, int amount) {
        return Component.literal((String)" ".repeat(amount)).append(component);
    }

    private static String formatNutrientAmount(float value, boolean consumesNutrients) {
        if (value < 0.0f) {
            if (consumesNutrients) {
                return String.format("+%.0f", Float.valueOf(Math.abs(value) * 100.0f));
            }
            return String.format("+%.0f", (double)Math.abs(value) * 0.3 * 100.0);
        }
        return String.format("%.0f", Float.valueOf(value * 100.0f));
    }

    @Nullable
    default public PlantNutrients getNutrientsInfo() {
        return null;
    }

    @Nullable
    default public ClimateRange getClimateRangeInfo() {
        return null;
    }

    @Nullable
    default public List<Lifecycle> getLifecycleInfo() {
        return null;
    }

    default public int getGrowthTimeInfo() {
        return -1;
    }

    public record PlantNutrients(float nitrogen, float phosphorus, float potassium) {
    }
}

