/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.dries007.tfc.common.LevelTier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.items.ProspectResult;
import net.dries007.tfc.common.items.ToolItem;
import net.dries007.tfc.network.ProspectedPacket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.ProspectedEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class PropickItem
extends ToolItem {
    public static final int RADIUS = 12;
    public static final int COOLDOWN = 10;
    private static final Map<Block, Block> REPRESENTATIVE_BLOCKS = new IdentityHashMap<Block, Block>();
    private final float falseNegativeChance;

    public static synchronized void registerRepresentative(Block representative, Block ... blocks) {
        for (Block block : blocks) {
            REPRESENTATIVE_BLOCKS.put(block, representative);
        }
    }

    public static Block getRepresentative(Block block) {
        return REPRESENTATIVE_BLOCKS.getOrDefault(block, block);
    }

    public static void registerDefaultRepresentativeBlocks() {
        TFCBlocks.GRADED_ORES.forEach((rock, ores) -> ores.forEach((ore, blocks) -> PropickItem.registerRepresentative((Block)((TFCBlocks.Id)blocks.get((Object)Ore.Grade.NORMAL)).get(), (Block)((TFCBlocks.Id)blocks.get((Object)Ore.Grade.RICH)).get(), (Block)((TFCBlocks.Id)blocks.get((Object)Ore.Grade.POOR)).get())));
    }

    public static Object2IntMap<Block> scanAreaFor(Level level, BlockPos center, int radius, TagKey<Block> tag) {
        Object2IntOpenHashMap results = new Object2IntOpenHashMap();
        for (BlockPos cursor : BlockPos.betweenClosed((int)(center.getX() - radius), (int)(center.getY() - radius), (int)(center.getZ() - radius), (int)(center.getX() + radius), (int)(center.getY() + radius), (int)(center.getZ() + radius))) {
            Block block = PropickItem.getRepresentative(level.getBlockState(cursor).getBlock());
            if (!Helpers.isBlock(block, tag)) continue;
            results.mergeInt((Object)block, 1, Integer::sum);
        }
        return results;
    }

    public PropickItem(LevelTier tier, Item.Properties properties) {
        super(tier, TFCTags.Blocks.MINEABLE_WITH_PROPICK, properties);
        this.falseNegativeChance = 0.3f - (float)Mth.clamp((int)tier.level(), (int)0, (int)5) * 0.060000002f;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        if (player instanceof ServerPlayer) {
            ArrayList stateKeys;
            int amount;
            Object2IntMap<Block> states;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundType sound = state.getSoundType((LevelReader)level, pos, (Entity)player);
            Random random = new Random();
            level.playSound(player, pos, sound.getHitSound(), SoundSource.PLAYERS, sound.getVolume(), sound.getPitch());
            Helpers.damageItem(context.getItemInHand(), (LivingEntity)player, context.getHand());
            player.getCooldowns().addCooldown((Item)this, 10);
            Block found = state.getBlock();
            random.setSeed(Helpers.hash(19827384739241223L, pos));
            ProspectResult result = Helpers.isBlock(state, TFCTags.Blocks.PROSPECTABLE) ? ProspectResult.FOUND : (random.nextFloat() < this.falseNegativeChance ? ProspectResult.NOTHING : ((states = PropickItem.scanAreaFor(level, pos, 12, TFCTags.Blocks.PROSPECTABLE)).isEmpty() ? ProspectResult.NOTHING : ((amount = states.getOrDefault((Object)(found = (Block)(stateKeys = new ArrayList(states.keySet())).get(random.nextInt(stateKeys.size()))), 1)) < 10 ? ProspectResult.TRACES : (amount < 20 ? ProspectResult.SMALL : (amount < 40 ? ProspectResult.MEDIUM : (amount < 80 ? ProspectResult.LARGE : ProspectResult.VERY_LARGE))))));
            NeoForge.EVENT_BUS.post((Event)new ProspectedEvent(player, result, found));
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ProspectedPacket(found, result), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (flag.isAdvanced()) {
            tooltip.add((Component)Component.translatable((String)"tfc.tooltip.propick.accuracy", (Object[])new Object[]{(int)(100.0f * (1.0f - this.falseNegativeChance))}).withStyle(ChatFormatting.GRAY));
        }
    }
}

