/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.ICropBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RottenCompostItem
extends Item {
    public RottenCompostItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Block block;
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (state.hasProperty(DoubleCropBlock.PART) && state.getValue(DoubleCropBlock.PART) == DoubleCropBlock.Part.TOP) {
            pos = pos.below();
            state = level.getBlockState(pos);
        }
        if ((block = state.getBlock()) instanceof ICropBlock) {
            BlockEntity blockEntity;
            ICropBlock cropBlock = (ICropBlock)block;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof CropBlockEntity) {
                CropBlockEntity cropBlockEntity = (CropBlockEntity)blockEntity;
                boolean mature = cropBlockEntity.getGrowth() >= 1.0f;
                cropBlock.die(level, pos, state, mature);
                Helpers.playSound(level, pos, (SoundEvent)TFCSounds.FERTILIZER_USE.get());
                Player player = context.getPlayer();
                if (player instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(player2, pos, context.getItemInHand());
                    TFCAdvancements.ROTTEN_COMPOST_KILL.trigger(player2);
                }
                context.getItemInHand().shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }
}

