/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.items.PlantableInfo;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class SeedItem
extends ItemNameBlockItem
implements PlantableInfo {
    private final PlantableInfo.PlantNutrients nutrients;
    private final Supplier<ClimateRange> climateRange;

    public SeedItem(Crop crop, Block block, Item.Properties properties) {
        super(block, properties);
        this.nutrients = new PlantableInfo.PlantNutrients(crop.getNitrogen(), crop.getPhosphorous(), crop.getPotassium());
        this.climateRange = crop.getClimateRange();
    }

    @Override
    @Nullable
    public PlantableInfo.PlantNutrients getNutrientsInfo() {
        return this.nutrients;
    }

    @Override
    @Nullable
    public ClimateRange getClimateRangeInfo() {
        return this.climateRange.get();
    }
}

