/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public record BlastFurnaceRecipe(SizedFluidIngredient inputFluid, Ingredient catalyst, FluidStack outputFluid) implements INoopInputRecipe,
IRecipePredicate<FluidStack>
{
    public static final MapCodec<BlastFurnaceRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid").forGetter(c -> c.inputFluid), (App)Ingredient.CODEC.fieldOf("catalyst").forGetter(c -> c.catalyst), (App)FluidStack.CODEC.fieldOf("result").forGetter(c -> c.outputFluid)).apply((Applicative)i, BlastFurnaceRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlastFurnaceRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedFluidIngredient.STREAM_CODEC, c -> c.inputFluid, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.catalyst, (StreamCodec)FluidStack.STREAM_CODEC, c -> c.outputFluid, BlastFurnaceRecipe::new);

    @Nullable
    public static BlastFurnaceRecipe get(Level level, ItemStack stack) {
        HeatingRecipe heatRecipe = HeatingRecipe.getRecipe(stack);
        if (heatRecipe != null) {
            FluidStack moltenFluid = heatRecipe.assembleFluid(stack);
            for (RecipeHolder recipe : RecipeHelpers.getRecipes(level, TFCRecipeTypes.BLAST_FURNACE)) {
                if (!((BlastFurnaceRecipe)recipe.value()).inputFluid.ingredient().test(moltenFluid)) continue;
                return (BlastFurnaceRecipe)recipe.value();
            }
        }
        return null;
    }

    @Nullable
    public static BlastFurnaceRecipe get(Level level, FluidStack inputFluid) {
        return (BlastFurnaceRecipe)RecipeHelpers.unbox(RecipeHelpers.getHolder(level, TFCRecipeTypes.BLAST_FURNACE, inputFluid));
    }

    @Override
    public boolean matches(FluidStack input) {
        return this.inputFluid.ingredient().test(input);
    }

    public boolean matchesInput(ItemStack stack) {
        HeatingRecipe heat = HeatingRecipe.getRecipe(stack);
        if (heat != null) {
            return this.matches(heat.assembleFluid(stack));
        }
        return false;
    }

    public boolean matchesCatalyst(ItemStack stack) {
        return this.catalyst.test(stack);
    }

    public FluidStack assembleFluidOutput(FluidStack inputFluid) {
        int maximumRatio = inputFluid.getAmount() / this.inputFluid.amount();
        FluidStack outputFluid = this.outputFluid.copy();
        inputFluid.shrink(maximumRatio * this.inputFluid.amount());
        outputFluid.setAmount(this.outputFluid.getAmount() * maximumRatio);
        return outputFluid;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.BLAST_FURNACE.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.BLAST_FURNACE.get();
    }
}

