/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public class BloomeryRecipe
implements INoopInputRecipe {
    public static final MapCodec<BloomeryRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid").forGetter(c -> c.inputFluid), (App)SizedIngredient.FLAT_CODEC.fieldOf("catalyst").forGetter(c -> c.catalyst), (App)ItemStackProvider.CODEC.fieldOf("result").forGetter(c -> c.result), (App)Codec.INT.fieldOf("duration").forGetter(c -> c.duration)).apply((Applicative)i, BloomeryRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BloomeryRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedFluidIngredient.STREAM_CODEC, c -> c.inputFluid, (StreamCodec)SizedIngredient.STREAM_CODEC, c -> c.catalyst, ItemStackProvider.STREAM_CODEC, c -> c.result, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.duration, BloomeryRecipe::new);
    private final SizedFluidIngredient inputFluid;
    private final SizedIngredient catalyst;
    private final ItemStackProvider result;
    private final int duration;

    public BloomeryRecipe(SizedFluidIngredient inputFluid, SizedIngredient catalyst, ItemStackProvider result, int duration) {
        this.inputFluid = inputFluid;
        this.catalyst = catalyst;
        this.result = result;
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public SizedIngredient getCatalyst() {
        return this.catalyst;
    }

    public SizedFluidIngredient getInputFluid() {
        return this.inputFluid;
    }

    public boolean matchesInput(ItemStack stack) {
        return this.consumeInput(stack) != null;
    }

    public boolean matchesInput(FluidStack stack) {
        return this.inputFluid.ingredient().test(stack);
    }

    public boolean matchesCatalyst(ItemStack stack) {
        return this.catalyst.test(stack);
    }

    @Nullable
    public FluidStack consumeInput(ItemStack stack) {
        FluidStack fluid;
        HeatingRecipe heat = HeatingRecipe.getRecipe(stack);
        if (heat != null && this.matchesInput(fluid = heat.assembleFluid(stack))) {
            return fluid;
        }
        return null;
    }

    public ItemStack assembleOutput() {
        return this.result.getEmptyStack();
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.getEmptyStack();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.BLOOMERY.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.BLOOMERY.get();
    }
}

