/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FoodCombiningCraftingRecipe
extends CustomRecipe {
    public static final FoodCombiningCraftingRecipe INSTANCE = new FoodCombiningCraftingRecipe();

    private FoodCombiningCraftingRecipe() {
        super(CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingInput input, Level level) {
        int notEmptyCount = 0;
        ItemStack foodStack = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            ++notEmptyCount;
            if (!FoodCapability.has(stack)) {
                return false;
            }
            if (foodStack.isEmpty()) {
                foodStack = stack;
                continue;
            }
            if (FoodCapability.areStacksStackableExceptCreationDate(stack, foodStack)) continue;
            return false;
        }
        return notEmptyCount > 1;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack resultStack = ItemStack.EMPTY;
        int outputAmount = 0;
        long minCreationDate = -1L;
        for (int i = 0; i < input.size(); ++i) {
            IFood cap;
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty() || (cap = FoodCapability.get(stack)) == null) continue;
            ++outputAmount;
            if (minCreationDate == -1L || minCreationDate > cap.getCreationDate()) {
                minCreationDate = cap.getCreationDate();
            }
            if (!resultStack.isEmpty()) continue;
            resultStack = stack.copy();
        }
        resultStack.setCount(outputAmount);
        long date = minCreationDate;
        FoodCapability.setCreationDate(resultStack, date);
        return resultStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        return NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.FOOD_COMBINING_CRAFTING.get();
    }
}

