/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.dries007.tfc.common.component.glass.GlassOperation;
import net.dries007.tfc.common.component.glass.GlassOperations;
import net.dries007.tfc.common.component.glass.GlassWorking;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record GlassworkingRecipe(List<GlassOperation> operations, Ingredient batchItem, ItemStack resultItem) implements INoopInputRecipe,
IRecipePredicate<ItemStack>
{
    public static final MapCodec<GlassworkingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)GlassOperation.REGISTRY.byNameCodec().listOf().fieldOf("operations").forGetter(c -> c.operations), (App)Ingredient.CODEC.fieldOf("batch").forGetter(c -> c.batchItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(c -> c.resultItem)).apply((Applicative)i, GlassworkingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GlassworkingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry(GlassOperation.KEY).apply(ByteBufCodecs.list()), c -> c.operations, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.batchItem, (StreamCodec)ItemStack.STREAM_CODEC, c -> c.resultItem, GlassworkingRecipe::new);

    @Nullable
    public static GlassworkingRecipe get(Level level, ItemStack stack) {
        return (GlassworkingRecipe)RecipeHelpers.unbox(RecipeHelpers.getHolder(level, TFCRecipeTypes.GLASSWORKING, stack));
    }

    @Override
    public boolean matches(ItemStack input) {
        GlassOperations data = GlassWorking.get(input);
        return this.operations.equals(data.steps()) && this.batchItem.test(data.batch());
    }

    @Override
    public ItemStack getResultItem(@Nullable HolderLookup.Provider registries) {
        return this.resultItem.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.GLASSWORKING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.GLASSWORKING.get();
    }
}

