/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import java.util.ArrayList;
import java.util.Optional;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.misc.TFCFallingBlockEntity;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.BlockRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.Support;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class LandslideRecipe
extends BlockRecipe {
    public static final IndirectHashCollection<Block, LandslideRecipe> CACHE = IndirectHashCollection.createForRecipe(recipe -> recipe.getBlockIngredient().blocks(), TFCRecipeTypes.LANDSLIDE);
    private static final LandslideRecipe FALLBACK = new LandslideRecipe();

    public static boolean canLandslide(BlockState input) {
        return LandslideRecipe.getRecipe(input) != null;
    }

    @Nullable
    public static LandslideRecipe getRecipe(BlockState input) {
        @Nullable LandslideRecipe recipe = RecipeHelpers.getRecipe(CACHE, input, input.getBlock());
        return recipe == null && FALLBACK.matches(input) ? FALLBACK : recipe;
    }

    public static boolean tryLandslide(Level level, BlockPos pos, BlockState state) {
        BlockPos fallPos;
        if (!level.isClientSide() && TFCConfig.SERVER.enableBlockLandslides.get().booleanValue() && (fallPos = LandslideRecipe.getLandslidePos(level, pos, state)) != null) {
            LandslideRecipe recipe = LandslideRecipe.getRecipe(state);
            if (recipe != null) {
                BlockState fallingState = recipe.assembleBlock(state);
                if (!fallPos.equals((Object)pos)) {
                    level.removeBlock(pos, false);
                    if (!FluidHelpers.isAirOrEmptyFluid(level.getBlockState(fallPos))) {
                        level.destroyBlock(fallPos, true);
                    }
                }
                if (TFCConfig.SERVER.farmlandMakesTheBestRaceTracks.get().booleanValue()) {
                    level.setBlockAndUpdate(fallPos, fallingState);
                } else {
                    level.setBlock(fallPos, fallingState, 18);
                }
                level.playSound(null, pos, (SoundEvent)TFCSounds.DIRT_SLIDE_SHORT.get(), SoundSource.BLOCKS, 0.4f, 1.0f);
                level.addFreshEntity((Entity)new TFCFallingBlockEntity(level, (double)fallPos.getX() + 0.5, fallPos.getY(), (double)fallPos.getZ() + 0.5, fallingState, 0.8f, 10));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static BlockPos getLandslidePos(Level level, BlockPos pos, BlockState fallingState) {
        if (Support.isSupported((BlockGetter)level, pos)) {
            return null;
        }
        if (TFCFallingBlockEntity.canFallThrough((BlockGetter)level, pos.below(), Direction.DOWN, fallingState)) {
            return pos;
        }
        if (!LandslideRecipe.isSupportedOnSide((BlockGetter)level, pos, Direction.UP)) {
            int supportedDirections = 0;
            ArrayList<BlockPos> possibleDirections = new ArrayList<BlockPos>();
            for (Direction side : Direction.Plane.HORIZONTAL) {
                if (LandslideRecipe.isSupportedOnSide((BlockGetter)level, pos, side)) {
                    if (++supportedDirections < 2) continue;
                    return null;
                }
                BlockPos posSide = pos.relative(side);
                BlockPos posSideBelow = posSide.below();
                if (!TFCFallingBlockEntity.canFallThrough((BlockGetter)level, posSide, side, fallingState) || !TFCFallingBlockEntity.canFallThrough((BlockGetter)level, posSideBelow, Direction.DOWN)) continue;
                possibleDirections.add(posSide);
            }
            if (!possibleDirections.isEmpty()) {
                return (BlockPos)possibleDirections.get(level.getRandom().nextInt(possibleDirections.size()));
            }
        }
        return null;
    }

    public static boolean isSupportedOnSide(BlockGetter world, BlockPos pos, Direction side) {
        BlockPos sidePos = pos.relative(side);
        BlockState sideState = world.getBlockState(sidePos);
        return sideState.isFaceSturdy(world, sidePos, side.getOpposite()) || Helpers.isBlock(sideState, TFCTags.Blocks.SUPPORTS_LANDSLIDE);
    }

    public LandslideRecipe(BlockIngredient ingredient, BlockState output) {
        super(ingredient, Optional.of(output));
    }

    LandslideRecipe(BlockIngredient ingredient, Optional<BlockState> output) {
        super(ingredient, output);
    }

    LandslideRecipe() {
        super(BlockIngredient.of(TFCTags.Blocks.CAN_LANDSLIDE), Optional.empty());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.LANDSLIDE.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.LANDSLIDE.get();
    }
}

