/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.recipes.ItemRecipe;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class ScrapingRecipe
extends ItemRecipe {
    public static final IndirectHashCollection<Item, ScrapingRecipe> CACHE = IndirectHashCollection.createForRecipe(ItemRecipe::getValidItems, TFCRecipeTypes.SCRAPING);
    public static final MapCodec<ScrapingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)ItemStackProvider.CODEC.fieldOf("result").forGetter(c -> c.result), (App)ResourceLocation.CODEC.fieldOf("input_texture").forGetter(c -> c.inputTexture), (App)ResourceLocation.CODEC.fieldOf("output_texture").forGetter(c -> c.outputTexture), (App)ItemStackProvider.CODEC.optionalFieldOf("result_item", (Object)ItemStackProvider.empty()).forGetter(c -> c.extraDrop)).apply((Applicative)i, ScrapingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ScrapingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.ingredient, ItemStackProvider.STREAM_CODEC, c -> c.result, (StreamCodec)ResourceLocation.STREAM_CODEC, c -> c.inputTexture, (StreamCodec)ResourceLocation.STREAM_CODEC, c -> c.outputTexture, ItemStackProvider.STREAM_CODEC, c -> c.extraDrop, ScrapingRecipe::new);
    private final ResourceLocation inputTexture;
    private final ResourceLocation outputTexture;
    private final ItemStackProvider extraDrop;

    @Nullable
    public static ScrapingRecipe getRecipe(ItemStack stack) {
        return RecipeHelpers.getRecipe(CACHE, stack, stack.getItem());
    }

    public ScrapingRecipe(Ingredient ingredient, ItemStackProvider result, ResourceLocation inputTexture, ResourceLocation outputTexture, ItemStackProvider extraDrop) {
        super(ingredient, result);
        this.inputTexture = inputTexture;
        this.outputTexture = outputTexture;
        this.extraDrop = extraDrop;
    }

    public ResourceLocation getInputTexture() {
        return this.inputTexture;
    }

    public ResourceLocation getOutputTexture() {
        return this.outputTexture;
    }

    public ItemStackProvider getExtraDrop() {
        return this.extraDrop;
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.SCRAPING.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.SCRAPING.get();
    }
}

