/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.common.recipes.outputs.PotOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class SimplePotRecipe
extends PotRecipe {
    public static final MapCodec<SimplePotRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)PotRecipe.CODEC.forGetter(c -> c), (App)FluidStack.CODEC.optionalFieldOf("fluid_output", (Object)FluidStack.EMPTY).forGetter(c -> c.outputFluid), (App)ItemStackProvider.CODEC.listOf(0, 5).optionalFieldOf("item_output", List.of()).forGetter(c -> c.outputItems), (App)Codec.BOOL.optionalFieldOf("uses_all_fluid", (Object)true).forGetter(c -> c.usesAllFluid)).apply((Applicative)i, SimplePotRecipe::new)).validate(recipe -> {
        boolean anyProvidersDependOnInput = recipe.outputItems.stream().anyMatch(ItemStackProvider::dependsOnInput);
        if (anyProvidersDependOnInput && recipe.outputItems.size() != recipe.itemIngredients.size()) {
            return DataResult.error(() -> "At least one output is an ItemStackProvider that depends on the input. This is only allowed if there are (1) equal number of inputs and outputs, and (2) All inputs and outputs are the same");
        }
        return DataResult.success((Object)recipe);
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, SimplePotRecipe> STREAM_CODEC = StreamCodec.composite(PotRecipe.STREAM_CODEC, c -> c, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, c -> c.outputFluid, (StreamCodec)ItemStackProvider.STREAM_CODEC.apply(ByteBufCodecs.list((int)5)), c -> c.outputItems, (StreamCodec)ByteBufCodecs.BOOL, c -> c.usesAllFluid, SimplePotRecipe::new);
    protected final FluidStack outputFluid;
    protected final List<ItemStackProvider> outputItems;
    protected final boolean usesAllFluid;

    public SimplePotRecipe(PotRecipe base, FluidStack outputFluid, List<ItemStackProvider> outputProviders, boolean usesAllFluid) {
        super(base);
        this.outputFluid = outputFluid;
        this.outputItems = outputProviders;
        this.usesAllFluid = usesAllFluid;
    }

    public FluidStack getDisplayFluid() {
        return this.outputFluid;
    }

    public List<ItemStackProvider> getOutputItems() {
        return this.outputItems;
    }

    @Override
    public PotOutput getOutput(PotBlockEntity.PotInventory inventory) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(5);
        ArrayList<ItemStackProvider> providers = new ArrayList<ItemStackProvider>(this.outputItems);
        for (int i = 4; i < inventory.getSlots() && !providers.isEmpty(); ++i) {
            ItemStack input = inventory.getStackInSlot(i);
            if (input.isEmpty() && !this.itemIngredients.isEmpty()) continue;
            outputs.add(((ItemStackProvider)providers.removeFirst()).getSingleStack(input));
        }
        return new SimpleOutput(this.usesAllFluid ? this.outputFluid.copy() : this.favorNewFluidStack(inventory.getFluidHandler().getFluidInTank(0), this.outputFluid), outputs);
    }

    public FluidStack favorNewFluidStack(FluidStack input, FluidStack output) {
        if ((input = input.copy()).getAmount() > this.fluidIngredient.amount() && output.isEmpty()) {
            input.setAmount(input.getAmount() - this.fluidIngredient.amount());
            return input;
        }
        return output.copy();
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.POT_SIMPLE.get();
    }

    record SimpleOutput(FluidStack fluidOutput, List<ItemStack> itemOutputs) implements PotOutput
    {
        @Override
        public void onFinish(PotBlockEntity.PotInventory inventory) {
            for (int i = 0; i < this.itemOutputs.size(); ++i) {
                inventory.setStackInSlot(4 + i, this.itemOutputs.get(i));
            }
            inventory.clearFluid();
            inventory.fill(this.fluidOutput, IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

