/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.function.Function;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.component.Bowl;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.common.component.food.Nutrient;
import net.dries007.tfc.common.component.item.ItemListComponent;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.outputs.PotOutput;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.BlockEntityTooltip;
import net.dries007.tfc.util.tooltip.BlockEntityTooltips;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class SoupPotRecipe
extends PotRecipe {
    public static final MapCodec<SoupPotRecipe> CODEC = PotRecipe.CODEC.xmap(SoupPotRecipe::new, Function.identity());
    public static final StreamCodec<RegistryFriendlyByteBuf, SoupPotRecipe> STREAM_CODEC = PotRecipe.STREAM_CODEC.map(SoupPotRecipe::new, Function.identity());
    public static final PotOutput.OutputType OUTPUT_TYPE = (provider, nbt) -> {
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("item"));
        return new SoupOutput(stack);
    };
    public static final int SOUP_HUNGER_VALUE = 4;
    public static final float SOUP_DECAY_MODIFIER = 3.5f;

    public static int ingredientsToServings(int ingredientCount) {
        return (int)((float)ingredientCount / 2.0f) + 1;
    }

    public SoupPotRecipe(PotRecipe base) {
        super(base);
    }

    @Override
    public PotOutput getOutput(PotBlockEntity.PotInventory inventory) {
        inventory.clearFluid();
        int ingredientCount = 0;
        float water = 20.0f;
        float saturation = 2.0f;
        float[] nutrition = new float[Nutrient.TOTAL];
        ItemStack soupStack = ItemStack.EMPTY;
        ArrayList<ItemStack> itemIngredients = new ArrayList<ItemStack>();
        for (int i = 4; i <= 8; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            @Nullable IFood food = FoodCapability.get(stack);
            if (food == null) continue;
            itemIngredients.add(stack);
            if (food.isRotten()) {
                ingredientCount = 0;
                break;
            }
            FoodData data = food.getData();
            water += data.water();
            saturation += data.saturation();
            Nutrient[] nutrientArray = Nutrient.VALUES;
            int n = nutrientArray.length;
            for (int j = 0; j < n; ++j) {
                Nutrient nutrient = nutrientArray[j];
                int n2 = nutrient.ordinal();
                nutrition[n2] = nutrition[n2] + data.nutrient(nutrient);
            }
            ++ingredientCount;
        }
        if (ingredientCount > 0) {
            float multiplier = 1.0f - 0.05f * (float)ingredientCount;
            water *= multiplier;
            saturation *= multiplier;
            Nutrient maxNutrient = Nutrient.GRAIN;
            float maxNutrientValue = 0.0f;
            for (Nutrient nutrient : Nutrient.VALUES) {
                int idx;
                int n = idx = nutrient.ordinal();
                nutrition[n] = nutrition[n] * multiplier;
                if (!(nutrition[idx] > maxNutrientValue)) continue;
                maxNutrientValue = nutrition[idx];
                maxNutrient = nutrient;
            }
            soupStack = new ItemStack((ItemLike)TFCItems.SOUPS.get((Object)maxNutrient).get(), SoupPotRecipe.ingredientsToServings(ingredientCount));
            soupStack.set(TFCComponents.INGREDIENTS, (Object)ItemListComponent.of(itemIngredients));
            FoodCapability.setFoodForDynamicItemOnCreate(soupStack, new FoodData(4, water, saturation, 0, nutrition, 3.5f));
        }
        return new SoupOutput(soupStack);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.POT_SOUP.get();
    }

    public record SoupOutput(ItemStack stack) implements PotOutput
    {
        @Override
        public boolean isEmpty() {
            return this.stack.isEmpty();
        }

        @Override
        public ItemInteractionResult onInteract(PotBlockEntity entity, Player player, ItemStack clickedWith) {
            if (Helpers.isItem(clickedWith.getItem(), TFCTags.Items.SOUP_BOWLS) && !this.stack.isEmpty()) {
                this.stack.set(TFCComponents.BOWL, (Object)Bowl.of(clickedWith));
                clickedWith.shrink(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.stack.split(1));
                return ItemInteractionResult.sidedSuccess((boolean)player.level().isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }

        @Override
        public int getFluidColor() {
            return -5881324;
        }

        @Override
        public void write(HolderLookup.Provider provider, CompoundTag nbt) {
            nbt.put("item", this.stack.save(provider));
        }

        @Override
        public PotOutput.OutputType getType() {
            return OUTPUT_TYPE;
        }

        @Override
        public BlockEntityTooltip getTooltip() {
            return (level, state, pos, entity, tooltip) -> {
                BlockEntityTooltips.itemWithCount(tooltip, this.stack);
                FoodCapability.addTooltipInfo(this.stack, tooltip);
            };
        }
    }
}

