/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodTrait;
import net.dries007.tfc.common.recipes.ingredients.PreciseIngredient;
import net.dries007.tfc.common.recipes.ingredients.TFCIngredients;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.IngredientType;

public record HasTraitIngredient(Holder<FoodTrait> trait) implements PreciseIngredient
{
    public static final MapCodec<HasTraitIngredient> CODEC = FoodTrait.CODEC.fieldOf("trait").xmap(HasTraitIngredient::new, HasTraitIngredient::trait);
    public static final StreamCodec<RegistryFriendlyByteBuf, HasTraitIngredient> STREAM_CODEC = FoodTrait.STREAM_CODEC.map(HasTraitIngredient::new, HasTraitIngredient::trait);

    public static HasTraitIngredient of(Holder<FoodTrait> trait) {
        return new HasTraitIngredient(trait);
    }

    public boolean test(ItemStack stack) {
        return FoodCapability.hasTrait(stack, this.trait);
    }

    @Override
    public ItemStack modifyStackForDisplay(ItemStack stack) {
        return FoodCapability.applyTrait(stack, this.trait);
    }

    public IngredientType<?> getType() {
        return (IngredientType)TFCIngredients.HAS_TRAIT.get();
    }
}

