/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;

public interface KeyedIngredient
extends Predicate<ItemStack> {
    public Collection<Item> keys();

    public static KeyedIngredient of(Ingredient ingredient) {
        return KeyedIngredient.of((Predicate<ItemStack>)ingredient, () -> RecipeHelpers.itemKeys(ingredient));
    }

    public static <I extends RecipeInput, R extends Recipe<I>> KeyedIngredient ofMatchingAnyRecipeInput(Supplier<RecipeType<R>> type, IndirectHashCollection<Item, R> cache, Function<R, Ingredient> key) {
        return KeyedIngredient.of(stack -> !cache.getAll(stack.getItem()).isEmpty(), () -> RecipeHelpers.getRecipes(Helpers.getUnsafeRecipeManager(), type).stream().flatMap(r -> RecipeHelpers.stream((Ingredient)key.apply(r.value()))).toList());
    }

    public static KeyedIngredient of(final Predicate<ItemStack> test, final Supplier<Collection<Item>> keys) {
        return new KeyedIngredient(){

            @Override
            public Collection<Item> keys() {
                return (Collection)keys.get();
            }

            @Override
            public boolean test(ItemStack stack) {
                return test.test(stack);
            }
        };
    }
}

