/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifierType;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifiers;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public record ExtraProductModifier(ItemStack stack) implements ItemStackModifier
{
    public static final MapCodec<ExtraProductModifier> CODEC = ItemStack.CODEC.fieldOf("stack").xmap(ExtraProductModifier::of, ExtraProductModifier::stack);
    public static final StreamCodec<RegistryFriendlyByteBuf, ExtraProductModifier> STREAM_CODEC = ItemStack.STREAM_CODEC.map(ExtraProductModifier::of, ExtraProductModifier::stack);

    public static ExtraProductModifier of(ItemStack stack) {
        return new ExtraProductModifier(FoodCapability.setTransientNonDecaying(stack));
    }

    @Override
    public ItemStack apply(ItemStack stack, ItemStack input, ItemStackModifier.Context context) {
        @Nullable Player player = RecipeHelpers.getCraftingPlayer();
        if (player != null && context == ItemStackModifier.Context.DEFAULT) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.stack().copy());
        }
        return stack;
    }

    @Override
    public ItemStackModifierType<?> type() {
        return (ItemStackModifierType)ItemStackModifiers.EXTRA_PRODUCT.get();
    }
}

