/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi;

import dev.emi.emi.api.EmiExclusionArea;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.compat.emi.stack.EmiSizedIngredient;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public class EmiHelpers {
    public static RegistryAccess registryAccess() {
        return ClientHelpers.getLevelOrThrow().registryAccess();
    }

    public static EmiIngredient toIngredient(SizedFluidIngredient ingredient) {
        return EmiIngredient.of(Arrays.stream(ingredient.getFluids()).map(s -> EmiStack.of((Fluid)s.getFluid())).toList(), (long)ingredient.amount());
    }

    public static EmiIngredient toIngredient(SizedIngredient ingredient) {
        return new EmiSizedIngredient(ingredient);
    }

    public static EmiIngredient toIngredient(BlockIngredient ingredient) {
        return EmiIngredient.of(ingredient.all().map(ItemStack::new).filter(item -> !item.isEmpty()).map(EmiStack::of).toList());
    }

    public static EmiIngredient toIngredient(List<Ingredient> ingredients) {
        return EmiIngredient.of(ingredients.stream().map(EmiIngredient::of).toList());
    }

    public static List<ItemStack> collapse(List<ItemStack> inputs, ItemStackProvider output) {
        if (inputs.isEmpty()) {
            return List.of(output.getEmptyStack());
        }
        return inputs.stream().map(output::getStack).map(EmiHelpers::setDefaultNonDecay).toList();
    }

    public static List<ItemStack> collapse(ItemStackProvider output) {
        return List.of(output.getEmptyStack());
    }

    public static List<ItemStack> collapse(ItemStackProvider provider, Ingredient ing) {
        return provider.dependsOnInput() ? EmiHelpers.collapse(List.of(ing.getItems()), provider) : EmiHelpers.collapse(provider);
    }

    public static ItemStack setDefaultNonDecay(ItemStack stack) {
        return EmiHelpers.setNewOrCurrentFoodFlag(stack, -2L);
    }

    public static EmiStack nonDecayStack(ItemStack stack) {
        return EmiStack.of((ItemStack)EmiHelpers.setDefaultNonDecay(stack));
    }

    public static ItemStack setNewOrCurrentFoodFlag(ItemStack stack, long flag) {
        @Nullable IFood food = FoodCapability.get(stack);
        if (food != null) {
            long creationDate = food.getCreationDate();
            if (creationDate == -2L || creationDate == -3L || creationDate == -4L) {
                return stack;
            }
            return FoodCapability.setCreationDate(stack, flag);
        }
        return stack;
    }

    static EmiIngredient damagedTool(EmiIngredient tool, int damage) {
        for (EmiStack stack : tool.getEmiStacks()) {
            ItemStack is = stack.getItemStack().copy();
            is.setDamageValue(damage);
            stack.setRemainder(EmiStack.of((ItemStack)is));
        }
        return tool;
    }

    static EmiWorldInteractionRecipe useItemOn(String id, EmiIngredient item, EmiIngredient target, EmiStack result) {
        return EmiHelpers.useItemOn(id, item, target, result, true);
    }

    private static EmiWorldInteractionRecipe useItemOn(String id, EmiIngredient item, EmiIngredient target, EmiStack result, boolean catalyst) {
        return EmiHelpers.useItemOn(id, List.of(item), target, result, catalyst);
    }

    static EmiWorldInteractionRecipe useItemOn(String id, List<EmiIngredient> items, EmiIngredient target, EmiStack result, boolean catalyst) {
        EmiWorldInteractionRecipe.Builder builder = EmiWorldInteractionRecipe.builder().id(EmiHelpers.syntheticId(id)).leftInput(target).output(result);
        for (EmiIngredient ingredient : items) {
            builder.rightInput(ingredient, catalyst);
        }
        return builder.build();
    }

    static <T extends AbstractContainerScreen<?>> EmiExclusionArea<T> inventoryTabExclusionArea() {
        return (screen, consumer) -> consumer.accept(new Bounds(screen.getGuiLeft() + screen.getXSize(), screen.getGuiTop(), 20, 120));
    }

    static Function<SlotWidget, SlotWidget> addTooltipToSlot(String key) {
        return slot -> slot.appendTooltip((Component)Component.translatable((String)key));
    }

    static ResourceLocation syntheticId(String id) {
        return Helpers.identifier("/" + id);
    }
}

