/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.FillingArrowWidget;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.dries007.tfc.compat.emi.recipe.ComparableRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public abstract class AutoLayoutRecipe<T extends Recipe<?>>
implements EmiRecipe,
ComparableRecipe {
    private final ResourceLocation id;
    private final EmiRecipeCategory category;
    protected final List<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
    protected final List<EmiIngredient> catalysts = new ArrayList<EmiIngredient>();
    protected final List<EmiStack> outputs = new ArrayList<EmiStack>();
    private Widget[] generatedWidgets;
    protected int width;
    protected int height;

    public AutoLayoutRecipe(EmiRecipeCategory category, ResourceLocation id, T recipe) {
        this.id = id;
        this.category = category;
    }

    protected void init(T recipe) {
        this.processRecipe(recipe);
        this.generatedWidgets = (Widget[])this.generateWidgets(recipe).toArray(Widget[]::new);
        int w = 0;
        int h = 0;
        for (Widget widget : this.generatedWidgets) {
            Bounds bounds = widget.getBounds();
            w = Math.max(w, bounds.right());
            h = Math.max(h, bounds.bottom());
        }
        this.width = w + this.getMargin() + this.getPaddingRight();
        this.height = h + this.getMargin() + this.getPaddingBottom();
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public int getDisplayWidth() {
        return this.width;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public void addWidgets(WidgetHolder widgets) {
        for (Widget widget : this.generatedWidgets) {
            widgets.add(widget);
        }
    }

    protected abstract void processRecipe(T var1);

    protected List<Widget> generateWidgets(T recipe) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        int x = this.getMargin() + this.getPaddingLeft();
        int y = this.getMargin() + this.getPaddingTop();
        int index = 0;
        for (EmiIngredient ingredient : this.getInputs()) {
            SlotWidget slot = this.generateInputSlot(ingredient, x, y, index);
            Bounds bounds = slot.getBounds();
            x = bounds.right() + 3;
            widgets.add((Widget)slot);
            ++index;
        }
        Widget middle = AutoLayoutRecipe.generateMiddleWidget(x, y);
        widgets.add(middle);
        x = middle.getBounds().right() + 3;
        index = 0;
        for (EmiStack stack : this.getOutputs()) {
            SlotWidget slot = this.generateOutputSlot(stack, x, y, index);
            Bounds bounds = slot.getBounds();
            x = bounds.right() + 3;
            widgets.add((Widget)slot);
            ++index;
        }
        return widgets;
    }

    protected static Widget generateMiddleWidget(int x, int y) {
        return new FillingArrowWidget(x, y, 3000);
    }

    protected SlotWidget generateInputSlot(EmiIngredient ingredient, int x, int y, int index) {
        return new SlotWidget(ingredient, x, y);
    }

    protected SlotWidget generateOutputSlot(EmiStack stack, int x, int y, int index) {
        return new SlotWidget((EmiIngredient)stack, x, y).recipeContext((EmiRecipe)this);
    }

    @Override
    public int compareTo(EmiRecipe other) {
        ResourceLocation otherId = other.getId();
        if (otherId != null) {
            return this.id.compareTo(other.getId());
        }
        return 0;
    }

    protected int getMargin() {
        return 4;
    }

    protected int getPaddingTop() {
        return 0;
    }

    protected int getPaddingBottom() {
        return 0;
    }

    protected int getPaddingLeft() {
        return 0;
    }

    protected int getPaddingRight() {
        return 0;
    }

    public static enum Position implements Function<Bounds, Integer>
    {
        TOP(Bounds::top),
        BOTTOM(Bounds::bottom),
        X(Bounds::x),
        Y(Bounds::y),
        WIDTH(Bounds::height),
        HEIGHT(Bounds::height),
        LEFT(Bounds::left),
        RIGHT(Bounds::right);

        private final Function<Bounds, Integer> function;

        private Position(Function<Bounds, Integer> function) {
            this.function = function;
        }

        @Override
        public Integer apply(Bounds bounds) {
            return this.function.apply(bounds);
        }
    }

    public static class WidgetLayout
    extends ArrayList<Widget> {
        private final Bounds initialPos;

        public WidgetLayout() {
            this.initialPos = new Bounds(0, 0, 0, 0);
        }

        public WidgetLayout(Bounds bounds) {
            this.initialPos = bounds;
        }

        public int last(Position p, int offset) {
            if (this.isEmpty()) {
                return p.apply(this.initialPos) + offset;
            }
            return p.apply(((Widget)this.getLast()).getBounds()) + offset;
        }

        public int last(Position p) {
            return this.last(p, 0);
        }

        public int index(int index, Position p, int offset) {
            if (this.isEmpty()) {
                return p.apply(this.initialPos) + offset;
            }
            return p.apply(((Widget)this.get(index)).getBounds()) + offset;
        }

        public int index(int index, Position p) {
            return this.index(index, p, 0);
        }

        public int max(Position p) {
            return this.stream().map(Widget::getBounds).mapToInt(p::apply).max().orElse(0);
        }

        public <T extends Widget> T addWidget(T widget) {
            this.add(widget);
            return widget;
        }
    }
}

