/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import net.dries007.tfc.common.recipes.AdvancedShapelessRecipe;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.widgets.CyclingSlotWidget;
import net.dries007.tfc.compat.emi.widgets.ItemStackProviderWidget;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EmiAdvancedShapelessRecipe
extends EmiCraftingRecipe {
    @Nullable
    private final EmiIngredient primaryIngredient;
    private final boolean isSpecial;
    private final ItemStackProvider provider;

    public EmiAdvancedShapelessRecipe(ResourceLocation id, AdvancedShapelessRecipe recipe) {
        super(recipe.getIngredients().stream().map(EmiIngredient::of).toList(), EmiHelpers.nonDecayStack(recipe.getResultItem((HolderLookup.Provider)EmiHelpers.registryAccess())), id, true);
        this.primaryIngredient = recipe.getPrimaryIngredient().map(EmiIngredient::of).orElse(null);
        this.isSpecial = recipe.isSpecial();
        this.provider = recipe.getResult();
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 60, 18);
        widgets.addTexture(EmiTexture.SHAPELESS, 97, 0);
        SlotWidget primary = null;
        for (int i = 0; i < 9; ++i) {
            if (i < this.input.size()) {
                EmiIngredient value = (EmiIngredient)this.input.get(i);
                SlotWidget slot = (SlotWidget)widgets.add((Widget)new CyclingSlotWidget(value, i, i % 3 * 18, i / 3 * 18));
                if (!value.equals((Object)this.primaryIngredient)) continue;
                primary = slot;
                continue;
            }
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)ItemStack.EMPTY), i % 3 * 18, i / 3 * 18);
        }
        if (primary != null) {
            ((ItemStackProviderWidget)widgets.add((Widget)new ItemStackProviderWidget(primary, this.provider, 1523, 92, 14))).large(true).recipeContext((EmiRecipe)this);
        } else {
            widgets.addSlot((EmiIngredient)this.output, 92, 14).large(true).recipeContext((EmiRecipe)this);
        }
    }

    public boolean supportsRecipeTree() {
        return !this.isSpecial;
    }
}

