/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import java.util.List;
import net.dries007.tfc.common.recipes.AlloyRecipe;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.AutoLayoutRecipe;
import net.dries007.tfc.util.AlloyRange;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.material.Fluid;

public class EmiAlloyingRecipe
extends AutoLayoutRecipe<AlloyRecipe> {
    private static final int COLUMN_SPACING = 70;
    private static final int Y_SPACING = 2;

    public EmiAlloyingRecipe(ResourceLocation id, AlloyRecipe recipe) {
        super(EmiIntegration.ALLOYING, id, recipe);
        this.init(recipe);
    }

    @Override
    protected void processRecipe(AlloyRecipe recipe) {
        List<AlloyRange> ranges = recipe.contents();
        double min = 0.0;
        for (AlloyRange range : ranges) {
            min += range.min();
        }
        double remaining = 1.0 - min;
        for (AlloyRange range : ranges) {
            double consumed = Math.min(range.max() - range.min(), remaining);
            double amount = range.min() + consumed;
            remaining -= consumed;
            this.inputs.add(EmiStack.of((Fluid)range.fluid(), (long)Math.round(amount * 100.0)));
        }
        this.outputs.add(EmiStack.of((Fluid)recipe.result(), (long)this.inputs.stream().mapToLong(EmiIngredient::getAmount).sum()));
    }

    @Override
    protected List<Widget> generateWidgets(AlloyRecipe recipe) {
        int firstColumn = this.getMargin() + this.getPaddingLeft();
        int secondColumn = firstColumn + 70;
        int startY = this.getMargin() + this.getPaddingTop();
        AutoLayoutRecipe.WidgetLayout widgets = new AutoLayoutRecipe.WidgetLayout();
        List<AlloyRange> ranges = recipe.contents();
        for (int i = 0; i < this.inputs.size(); ++i) {
            AlloyRange range = ranges.get(i);
            if (i == 0) {
                widgets.add(new SlotWidget((EmiIngredient)this.inputs.get(i), firstColumn, startY));
            } else if (i % 2 == 0) {
                widgets.add(new SlotWidget((EmiIngredient)this.inputs.get(i), firstColumn, widgets.last(AutoLayoutRecipe.Position.BOTTOM, 6)));
            } else {
                widgets.add(new SlotWidget((EmiIngredient)this.inputs.get(i), secondColumn, widgets.index(widgets.size() - 2, AutoLayoutRecipe.Position.TOP)));
            }
            int x = widgets.last(AutoLayoutRecipe.Position.RIGHT, 4);
            int y = widgets.last(AutoLayoutRecipe.Position.Y, widgets.last(AutoLayoutRecipe.Position.HEIGHT) / 2);
            widgets.add(new TextWidget(this.formatRange(range), x, y, -16777216, false).verticalAlign(TextWidget.Alignment.CENTER));
        }
        widgets.add(new SlotWidget((EmiIngredient)this.outputs.getFirst(), secondColumn + 70, widgets.max(AutoLayoutRecipe.Position.BOTTOM) / 2 - 7).recipeContext((EmiRecipe)this));
        return widgets;
    }

    protected FormattedCharSequence formatRange(AlloyRange range) {
        if (Math.abs(range.max() - range.min()) < 4.656612875245797E-10) {
            return Component.literal((String)String.format("%.0f%%", range.max() * 100.0)).getVisualOrderText();
        }
        return Component.literal((String)String.format("%.0f-%.0f%%", range.min() * 100.0, range.max() * 100.0)).getVisualOrderText();
    }
}

