/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import net.dries007.tfc.common.recipes.BlastFurnaceRecipe;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.BasicRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;

public class EmiBlastFurnaceRecipe
extends BasicRecipe<BlastFurnaceRecipe> {
    private final EmiIngredient catalyst;

    public EmiBlastFurnaceRecipe(ResourceLocation id, BlastFurnaceRecipe recipe) {
        super(EmiIntegration.BLAST_FURNACE, id, 98, 26);
        this.inputs.add(EmiHelpers.toIngredient(recipe.inputFluid()));
        this.catalyst = EmiIngredient.of((Ingredient)recipe.catalyst());
        this.outputs.add(EmiStack.of((Fluid)recipe.outputFluid().getFluid(), (long)recipe.outputFluid().getAmount()));
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.getFirst(), 6, 5);
        widgets.addSlot(this.catalyst, 26, 5);
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 76, 5).recipeContext((EmiRecipe)this);
        widgets.addFillingArrow(48, 5, 3000);
    }
}

