/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.AutoLayoutRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class EmiCastingRecipe
extends AutoLayoutRecipe<CastingRecipe> {
    public EmiCastingRecipe(ResourceLocation id, CastingRecipe recipe) {
        super(EmiIntegration.CASTING, id, recipe);
        this.init(recipe);
    }

    @Override
    protected void processRecipe(CastingRecipe recipe) {
        this.inputs.add(EmiIngredient.of((Ingredient)recipe.getIngredient()));
        this.inputs.add(EmiHelpers.toIngredient(recipe.getFluidIngredient()));
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem()));
    }

    @Override
    public int compareTo(EmiRecipe other) {
        if (other instanceof EmiCastingRecipe) {
            ResourceLocation fluidB;
            EmiCastingRecipe r = (EmiCastingRecipe)other;
            ResourceLocation fluidA = ((EmiStack)((EmiIngredient)this.inputs.getLast()).getEmiStacks().getFirst()).getId();
            int fluidCompare = fluidA.compareTo(fluidB = ((EmiStack)r.getInputs().getLast().getEmiStacks().getFirst()).getId());
            if (fluidCompare == 0) {
                ResourceLocation moldA = ((EmiStack)((EmiIngredient)this.inputs.getFirst()).getEmiStacks().getFirst()).getId();
                ResourceLocation moldB = ((EmiStack)r.getInputs().getFirst().getEmiStacks().getFirst()).getId();
                return moldA.compareTo(moldB);
            }
            return fluidCompare;
        }
        return super.compareTo(other);
    }
}

