/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.AnimatedTextureWidget;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.AutoLayoutRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class EmiHeatingRecipe
extends AutoLayoutRecipe<HeatingRecipe> {
    private static final EmiTexture emptyFlame = EmiTexture.EMPTY_FLAME;
    private static final EmiTexture fullFlame = EmiTexture.FULL_FLAME;
    protected final float temperature;
    protected final boolean outputsSolid;

    public EmiHeatingRecipe(ResourceLocation id, HeatingRecipe recipe) {
        super(EmiIntegration.HEATING, id, recipe);
        this.temperature = recipe.getTemperature();
        this.outputsSolid = !recipe.getResultItem((HolderLookup.Provider)EmiHelpers.registryAccess()).isEmpty() && recipe.getDisplayOutputFluid().isEmpty();
        this.init(recipe);
    }

    @Override
    protected void processRecipe(HeatingRecipe recipe) {
        this.inputs.add(EmiIngredient.of((Ingredient)recipe.getIngredient()));
        ItemStack itemOut = recipe.getResultItem((HolderLookup.Provider)EmiHelpers.registryAccess());
        FluidStack fluidOut = recipe.getDisplayOutputFluid();
        if (!itemOut.isEmpty()) {
            this.outputs.add(EmiHelpers.nonDecayStack(itemOut));
        }
        if (!fluidOut.isEmpty()) {
            this.outputs.add(EmiStack.of((Fluid)fluidOut.getFluid(), (long)fluidOut.getAmount()));
        }
    }

    @Override
    protected List<Widget> generateWidgets(HeatingRecipe recipe) {
        AutoLayoutRecipe.WidgetLayout widgets = new AutoLayoutRecipe.WidgetLayout(new Bounds(this.getMargin() + this.getPaddingLeft(), this.getMargin() + this.getPaddingTop(), 0, 0));
        widgets.add(new SlotWidget((EmiIngredient)this.inputs.getFirst(), widgets.last(AutoLayoutRecipe.Position.X), widgets.last(AutoLayoutRecipe.Position.Y)));
        widgets.add(new TextureWidget(EmiHeatingRecipe.emptyFlame.texture, widgets.last(AutoLayoutRecipe.Position.RIGHT, 4), widgets.last(AutoLayoutRecipe.Position.Y), EmiHeatingRecipe.emptyFlame.width, EmiHeatingRecipe.emptyFlame.height, EmiHeatingRecipe.emptyFlame.u, EmiHeatingRecipe.emptyFlame.v));
        widgets.add(new AnimatedTextureWidget(EmiHeatingRecipe.fullFlame.texture, widgets.last(AutoLayoutRecipe.Position.X), widgets.last(AutoLayoutRecipe.Position.Y), EmiHeatingRecipe.fullFlame.width, EmiHeatingRecipe.fullFlame.height, EmiHeatingRecipe.fullFlame.u, EmiHeatingRecipe.fullFlame.v, 8000, false, true, true));
        EmiStack output = this.outputs.isEmpty() ? EmiStack.EMPTY : (EmiStack)this.outputs.getLast();
        widgets.add(new SlotWidget((EmiIngredient)output, widgets.last(AutoLayoutRecipe.Position.RIGHT, 4), widgets.index(0, AutoLayoutRecipe.Position.Y)).recipeContext((EmiRecipe)this));
        return widgets;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        super.addWidgets(widgets);
        MutableComponent text = TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(this.temperature);
        if (text != null) {
            widgets.addText((Component)text, this.getDisplayWidth() / 2, this.getMargin() + 2, -16777216, true).horizontalAlign(TextWidget.Alignment.CENTER).verticalAlign(TextWidget.Alignment.CENTER);
        }
    }

    @Override
    public int compareTo(EmiRecipe other) {
        if (other instanceof EmiHeatingRecipe) {
            EmiHeatingRecipe heating = (EmiHeatingRecipe)other;
            return (int)(this.temperature - heating.temperature);
        }
        return super.compareTo(other);
    }

    public boolean hasSolidOutput() {
        return this.outputsSolid;
    }

    @Override
    protected int getPaddingTop() {
        return 10;
    }

    @Override
    protected int getPaddingLeft() {
        return 10;
    }

    @Override
    protected int getPaddingRight() {
        return 10;
    }
}

