/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import net.dries007.tfc.client.screen.SewingTableScreen;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.recipes.SewingRecipe;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.AutoLayoutRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.Tags;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;

public class EmiSewingRecipe
extends AutoLayoutRecipe<SewingRecipe> {
    private final SewingRecipe recipe;

    public EmiSewingRecipe(ResourceLocation id, SewingRecipe recipe) {
        super(EmiIntegration.SEWING, id, recipe);
        this.recipe = recipe;
        this.init(recipe);
    }

    @Override
    protected int getPaddingTop() {
        return 70;
    }

    @Override
    protected int getPaddingRight() {
        return 4;
    }

    @Override
    protected int getPaddingLeft() {
        return 4;
    }

    @Override
    protected void processRecipe(SewingRecipe recipe) {
        int i;
        int wool = 0;
        int burlap = 0;
        int string = 0;
        for (i = 0; i < 32; ++i) {
            int material = recipe.getSquare(i);
            if (material == 0) {
                ++burlap;
                continue;
            }
            if (material != 1) continue;
            ++wool;
        }
        for (i = 0; i < 45; ++i) {
            if (!recipe.getStitch(i)) continue;
            ++string;
        }
        if (wool > 0) {
            this.inputs.add(EmiIngredient.of(TFCTags.Items.SEWING_LIGHT_CLOTH, (long)Math.ceilDiv(wool, 8)));
        }
        if (burlap > 0) {
            this.inputs.add(EmiIngredient.of(TFCTags.Items.SEWING_DARK_CLOTH, (long)Math.ceilDiv(burlap, 8)));
        }
        if (string > 0) {
            this.inputs.add(EmiIngredient.of((TagKey)Tags.Items.STRINGS, (long)Math.ceilDiv(string, 16)));
        }
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)EmiHelpers.registryAccess())));
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        super.addWidgets(widgets);
        widgets.add((Widget)new SewingPatternWidget(6, 6, this.recipe));
    }

    public SewingRecipe getRecipe() {
        return this.recipe;
    }

    private static class SewingPatternWidget
    extends Widget {
        private static final int MATERIAL_SPRITE_SIZE = 12;
        private static final int OFFSET = 8;
        private final int x;
        private final int y;
        private final int height;
        private final int width;
        private final SewingRecipe recipe;

        public SewingPatternWidget(int x, int y, SewingRecipe recipe) {
            this.recipe = recipe;
            this.x = x;
            this.y = y;
            this.width = 112;
            this.height = 64;
        }

        public Bounds getBounds() {
            return new Bounds(this.x, this.y, this.width, this.height);
        }

        public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
            this.drawTex(draw, 0, 0, 8, 14, this.width, this.height);
            SewingTableScreen.forEachClothSquare((TriConsumer<Integer, Integer, Integer>)((TriConsumer)(xp, yp, i) -> {
                int material = this.recipe.getSquare((int)i);
                if (material != -1) {
                    if (material == 0) {
                        this.drawBurlap(draw, (int)xp, (int)yp);
                    } else {
                        this.drawWool(draw, (int)xp, (int)yp);
                    }
                }
                this.drawPips(draw, (int)xp, (int)yp);
            }));
            SewingTableScreen.forEachStitch((TriFunction<Integer, Integer, Integer, Boolean>)((TriFunction)(xp, yp, i) -> {
                if (this.recipe.getStitch((int)i)) {
                    this.drawStitch(draw, (int)xp, (int)yp);
                }
                return false;
            }));
        }

        private void drawTex(GuiGraphics draw, int xp, int yp, int u, int v, int w, int h) {
            draw.blit(SewingTableScreen.TEXTURE, this.x + xp, this.y + yp, u, v, w, h);
        }

        private void drawStitch(GuiGraphics draw, int xp, int yp) {
            this.drawTex(draw, xp * 12 + 8 - 2, yp * 12 + 8 - 2, 192, 0, 5, 5);
        }

        private void drawWool(GuiGraphics draw, int xp, int yp) {
            this.drawTex(draw, xp * 12 + 8, yp * 12 + 8, 208, 0, 12, 12);
        }

        private void drawBurlap(GuiGraphics draw, int xp, int yp) {
            this.drawTex(draw, xp * 12 + 8, yp * 12 + 8, 208, 16, 12, 12);
        }

        private void drawPips(GuiGraphics draw, int xp, int yp) {
            this.drawTex(draw, xp * 12 + 8, yp * 12 + 8, 208, 32, 12, 12);
        }
    }
}

