/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.SoupPotRecipe;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.recipe.EmiBasePotRecipe;
import net.dries007.tfc.compat.emi.widgets.CyclingSlotWidget;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class EmiSoupPotRecipe
extends EmiBasePotRecipe<SoupPotRecipe> {
    public EmiSoupPotRecipe(ResourceLocation id, SoupPotRecipe recipe) {
        super(id, recipe, 113, 80);
        int ingredientCount = 0;
        for (Ingredient ingredient : recipe.getItemIngredients()) {
            if (ingredient.isEmpty()) continue;
            ++ingredientCount;
            this.inputs.add(EmiIngredient.of((Ingredient)ingredient));
        }
        int servings = SoupPotRecipe.ingredientsToServings(ingredientCount);
        for (ItemLike itemLike : TFCItems.SOUPS.values()) {
            this.outputs.add(EmiHelpers.nonDecayStack(itemLike.asItem().getDefaultInstance().copyWithCount(servings)));
        }
    }

    @Override
    protected void addOutputWidgets(WidgetHolder widgets) {
        ((CyclingSlotWidget)widgets.add((Widget)new CyclingSlotWidget(this.outputs, 25, 90, 24))).recipeContext((EmiRecipe)this);
    }
}

